/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Trigger;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class CronType
implements Trigger {
    private static final L10N L = new L10N(CronType.class);
    private AtomicReference<QDate> _localCalendar = new AtomicReference();
    private String _text;
    private boolean[] _minutes;
    private boolean[] _hours;
    private boolean[] _days;
    private boolean[] _months;
    private boolean[] _daysOfWeek;

    public CronType() {
    }

    public CronType(String cron) {
        this.addText(cron);
    }

    public CronType(String second, String minute, String hour, String dayOfWeek, String dayOfMonth, String month, String year, Date start, Date end) {
        this._text = String.format("%s %s %s %s %s %s %s", second, minute, hour, dayOfWeek, dayOfMonth, month, year);
        this._minutes = this.parseRange(minute, 0, 59);
        this._hours = this.parseRange(hour, 0, 23);
        this._daysOfWeek = this.parseRange(dayOfWeek, 0, 7);
        if (this._daysOfWeek[7]) {
            this._daysOfWeek[0] = this._daysOfWeek[7];
        }
        this._days = this.parseRange(dayOfMonth, 1, 31);
        this._months = this.parseRange(month, 1, 12);
    }

    public void addText(String text) throws ConfigException {
        this._text = text = text.trim();
        String[] split = Pattern.compile("\\s+").split(text);
        if (split.length > 0) {
            this._minutes = this.parseRange(split[0], 0, 59);
        }
        this._hours = split.length > 1 ? this.parseRange(split[1], 0, 23) : this.parseRange("*", 0, 23);
        if (split.length > 2) {
            this._days = this.parseRange(split[2], 1, 31);
        }
        if (split.length > 3) {
            this._months = this.parseRange(split[3], 1, 12);
        }
        if (split.length > 4) {
            this._daysOfWeek = this.parseRange(split[4], 0, 7);
            if (this._daysOfWeek[7]) {
                this._daysOfWeek[0] = this._daysOfWeek[7];
            }
        }
    }

    private boolean[] parseRange(String range, int rangeMin, int rangeMax) throws ConfigException {
        boolean[] values = new boolean[rangeMax + 1];
        int j = 0;
        while (j < range.length()) {
            char ch = range.charAt(j);
            int min = 0;
            int max = 0;
            int step = 1;
            if (ch == '*') {
                min = rangeMin;
                max = rangeMax;
                ++j;
            } else if ('0' <= ch && ch <= '9') {
                while (j < range.length() && '0' <= (ch = range.charAt(j)) && ch <= '9') {
                    min = 10 * min + ch - 48;
                    ++j;
                }
                if (j < range.length() && ch == '-') {
                    ++j;
                    while (j < range.length() && '0' <= (ch = range.charAt(j)) && ch <= '9') {
                        max = 10 * max + ch - 48;
                        ++j;
                    }
                } else {
                    max = min;
                }
            } else {
                throw new ConfigException(L.l("'{0}' is an illegal cron range", range));
            }
            if (min < rangeMin) {
                throw new ConfigException(L.l("'{0}' is an illegal cron range (min value is too small)", range));
            }
            if (rangeMax < max) {
                throw new ConfigException(L.l("'{0}' is an illegal cron range (max value is too large)", range));
            }
            if (j < range.length() && (ch = range.charAt(j)) == '/') {
                step = 0;
                ++j;
                while (j < range.length() && '0' <= (ch = range.charAt(j)) && ch <= '9') {
                    step = 10 * step + ch - 48;
                    ++j;
                }
                if (step == 0) {
                    throw new ConfigException(L.l("'{0}' is an illegal cron range", range));
                }
            }
            if (range.length() > j) {
                if (ch == ',') {
                    ++j;
                } else {
                    throw new ConfigException(L.l("'{0}' is an illegal cron range", range));
                }
            }
            while (min <= max) {
                values[min] = true;
                min += step;
            }
        }
        return values;
    }

    public long nextTime(long now) {
        int hour;
        QDate cal = this.allocateCalendar();
        long time = now + 60000L - now % 60000L;
        cal.setGMTTime(time);
        int minute = this.nextInterval(this._minutes, cal.getMinute());
        if (minute < 0) {
            minute = this.nextInterval(this._minutes, 0);
            cal.setHour(cal.getHour() + 1);
        }
        if ((hour = this.nextInterval(this._hours, cal.getHour())) < 0) {
            hour = this.nextInterval(this._hours, 0);
            minute = this.nextInterval(this._minutes, 0);
            cal.setDayOfMonth(cal.getDayOfMonth() + 1);
        }
        int day = cal.getDayOfMonth();
        if (this._days != null && (day = this.nextInterval(this._days, cal.getDayOfMonth())) < 0) {
            cal.setMonth(cal.getMonth() + 1);
            cal.setDayOfMonth(1);
            day = this.nextInterval(this._days, cal.getDayOfMonth());
            hour = this.nextInterval(this._hours, 0);
            minute = this.nextInterval(this._minutes, 0);
        }
        if (this._daysOfWeek != null) {
            int oldDayOfWeek = cal.getDayOfWeek() - 1;
            int dayOfWeek = this.nextInterval(this._daysOfWeek, oldDayOfWeek);
            if (dayOfWeek >= 0) {
                day += dayOfWeek - oldDayOfWeek;
            } else {
                dayOfWeek = this.nextInterval(this._daysOfWeek, 0);
                day += dayOfWeek - oldDayOfWeek + 7;
            }
        }
        int month = cal.getMonth();
        int year = cal.getYear();
        this.freeCalendar(cal);
        long nextTime = this.nextTime(year, month, day, hour, minute);
        if (now < nextTime) {
            return nextTime;
        }
        return this.nextTime(now + 3600000L);
    }

    private long nextTime(int year, int month, int day, int hour, int minute) {
        QDate cal = this.allocateCalendar();
        cal.setLocalTime(0L);
        cal.setYear(year);
        cal.setMonth(month);
        cal.setDayOfMonth(day);
        cal.setHour(hour);
        cal.setMinute(minute);
        long time = cal.getGMTTime();
        this.freeCalendar(cal);
        return time;
    }

    public int nextInterval(boolean[] values, int now) {
        while (now < values.length) {
            if (values[now]) {
                return now;
            }
            ++now;
        }
        return -1;
    }

    public long prevTime(long now) {
        int hour;
        QDate cal = this.allocateCalendar();
        long time = now + 60000L - now % 60000L;
        cal.setGMTTime(time);
        int minute = this.prevInterval(this._minutes, cal.getMinute());
        if (minute < 0) {
            minute = this.prevInterval(this._minutes, this._minutes.length - 1);
            cal.setHour(cal.getHour() - 1);
        }
        if ((hour = this.prevInterval(this._hours, cal.getHour())) < 0) {
            hour = this.prevInterval(this._hours, this._hours.length - 1);
            minute = this.prevInterval(this._minutes, this._minutes.length - 1);
            cal.setDayOfMonth(cal.getDayOfMonth() - 1);
        }
        int day = cal.getDayOfMonth();
        if (this._days != null && (day = this.prevInterval(this._days, cal.getDayOfMonth())) < 0) {
            cal.setDayOfMonth(0);
            day = this.prevInterval(this._days, cal.getDayOfMonth());
            hour = this.prevInterval(this._hours, this._hours.length - 1);
            minute = this.prevInterval(this._minutes, this._minutes.length - 1);
        }
        if (this._daysOfWeek != null) {
            int oldDayOfWeek = cal.getDayOfWeek() - 1;
            int dayOfWeek = this.prevInterval(this._daysOfWeek, oldDayOfWeek);
            if (dayOfWeek >= 0) {
                day += dayOfWeek - oldDayOfWeek;
            } else {
                dayOfWeek = this.prevInterval(this._daysOfWeek, this._daysOfWeek.length - 1);
                day += dayOfWeek - oldDayOfWeek + 7;
            }
        }
        int month = cal.getMonth();
        int year = cal.getYear();
        long prevTime = this.prevTime(year, month, day, hour, minute);
        return prevTime;
    }

    private long prevTime(int year, int month, int day, int hour, int minute) {
        QDate cal = this.allocateCalendar();
        cal.setLocalTime(0L);
        cal.setYear(year);
        cal.setMonth(month);
        cal.setDayOfMonth(day);
        cal.setHour(hour);
        cal.setMinute(minute);
        long time = cal.getGMTTime();
        this.freeCalendar(cal);
        return time;
    }

    public int prevInterval(boolean[] values, int now) {
        while (now >= 0) {
            if (values[now]) {
                return now;
            }
            --now;
        }
        return -1;
    }

    private QDate allocateCalendar() {
        QDate cal = this._localCalendar.getAndSet(null);
        if (cal == null) {
            cal = QDate.createLocal();
        }
        return cal;
    }

    private void freeCalendar(QDate cal) {
        this._localCalendar.set(cal);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._text + "]";
    }
}

