/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.j2ee.BeanNameLiteral;
import com.caucho.config.types.BaseRef;
import com.caucho.config.types.InjectionTarget;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbRef
extends BaseRef {
    private static final L10N L = new L10N(EjbRef.class);
    private static final Logger log = Logger.getLogger(EjbRef.class.getName());
    private String _loc;
    private Context _context;
    private String _ejbRefName;
    private String _ejbRefType;
    private Class<?> _type;
    private Class<?> _home;
    private Class<?> _remote;
    private String _foreignName;
    private String _ejbLink;
    private Object _linkValue;
    private Object _target;
    private boolean _isInitBinding;
    private String _clientClassName;

    public EjbRef() {
    }

    public EjbRef(Context context) {
        this._context = context;
    }

    public EjbRef(Path modulePath) {
        super(modulePath);
    }

    public EjbRef(Path modulePath, String sourceEjbName) {
        super(modulePath, sourceEjbName);
    }

    public void setConfigLocation(String loc) {
        this._loc = loc;
    }

    public boolean isEjbLocalRef() {
        return false;
    }

    @Override
    public InjectionTarget getInjectionTarget() {
        return this._injectionTarget;
    }

    protected String getTagName() {
        return "<ejb-ref>";
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public void setDescription(String description) {
    }

    public void setClientClassName(String clientClassName) {
        this._clientClassName = clientClassName;
    }

    public void setEjbRefName(String name) {
        this._ejbRefName = name;
    }

    @Override
    public void setInjectionTarget(InjectionTarget injectionTarget) {
        this._injectionTarget = injectionTarget;
    }

    public String getEjbRefName() {
        return this._ejbRefName;
    }

    public void setEjbRefType(String type) {
        this._ejbRefType = type;
    }

    public void setHome(Class<?> home) {
        this._home = home;
    }

    public Class<?> getHome() {
        return this._home;
    }

    public void setRemote(Class<?> remote) {
        this._remote = remote;
    }

    public Class<?> getRemote() {
        return this._remote;
    }

    public Class<?> getLocal() {
        return null;
    }

    public void setForeignName(String foreignName) {
        this._foreignName = foreignName;
    }

    public void setEjbLink(String ejbLink) {
        this._ejbLink = ejbLink;
    }

    public String getEjbLink() {
        return this._ejbLink;
    }

    public void mergeFrom(EjbRef other) {
        if (this._foreignName == null) {
            this._foreignName = other._foreignName;
        }
        if (this._ejbLink == null) {
            this._ejbLink = other._ejbLink;
        }
        if (this._type == null) {
            this._type = other._type;
        }
        if (this._ejbRefType == null) {
            this._ejbRefType = other._ejbRefType;
        }
        if (this._home == null) {
            this._home = other._home;
        }
        if (this._remote == null) {
            this._remote = other._remote;
        }
        if (this._injectionTarget == null) {
            this._injectionTarget = other._injectionTarget;
        }
    }

    @Override
    public void deploy() {
        super.deploy();
        if (this._ejbRefType == null) {
            throw new ConfigException(L.l("<ejb-ref-type> is missing for <ejb-ref> {0}", this._ejbRefName));
        }
        this._type = this.getLocal();
        try {
            Jndi.bindDeepShort(this._ejbRefName, this);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public void bind() {
        this.deploy();
    }

    @Override
    public Object getValue() {
        Bean bean;
        String lookup = this.getLookupName();
        if (lookup != null) {
            return Jndi.lookup(lookup);
        }
        if (this._type == null) {
            throw new IllegalStateException(String.valueOf(this));
        }
        InjectManager injectManager = InjectManager.getCurrent();
        Set<Bean<?>> beans = null;
        if (this.getEjbLink() != null) {
            beans = injectManager.getBeans(this._type, new BeanNameLiteral(this.getEjbLink()));
        }
        if (beans == null || beans.size() == 0) {
            beans = injectManager.getBeans(this._type, new Annotation[0]);
        }
        try {
            bean = injectManager.resolve(beans);
        }
        catch (Exception e) {
            throw new ConfigException(L.l("{0} can't resolve a unique bean.\n  {1}", this, e.toString(), e));
        }
        if (bean == null) {
            throw new ConfigException(L.l("ejb-ref '{0}' is an unknown bean", this._type));
        }
        CreationalContext cxt = injectManager.createCreationalContext(bean);
        return injectManager.getReference(bean, this._type, cxt);
    }

    public Object getByType(Class<?> type) {
        try {
            if (this._home != null && type.isAssignableFrom(this._home)) {
                return this.createObject(null);
            }
            if (this._remote != null && type.isAssignableFrom(this._remote)) {
                return this.createObject(null);
            }
            if (this._foreignName != null) {
                int pos = this._foreignName.indexOf("#");
                if (pos > 0) {
                    String intf = this._foreignName.substring(++pos).replace("_", ".");
                    if (!type.getName().equals(intf)) {
                        return null;
                    }
                }
                String foreignName = this._foreignName.replace('.', '_');
                Object target = this._context != null ? this._context.lookup(foreignName) : Jndi.lookup(foreignName);
                if (target != null && type != null) {
                    return PortableRemoteObject.narrow((Object)target, type);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void resolve(Class<?> type) throws NamingException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, L.l("{0} resolving", this));
        }
        this._target = this._foreignName != null ? this.lookupByForeignJndi(this._foreignName, type) : (this._ejbLink != null ? this.lookupByLink(this._ejbLink, type) : this.lookupLocal(type));
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, L.l("{0} resolved", this));
        }
    }

    private Object lookupByLink(String link, Class<?> type) throws NamingException {
        String archiveName;
        Object target = null;
        int hashIndex = link.indexOf(35);
        if (hashIndex < 0) {
            archiveName = null;
            String ejbName = link;
        } else {
            archiveName = link.substring(0, hashIndex);
            String ejbName = link.substring(hashIndex + 1);
        }
        try {
            Path path = archiveName == null ? this._modulePath : this._modulePath.lookup(archiveName);
            throw new IllegalStateException();
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            throw new NamingException(L.l("{0} '{1}'  ejb-link '{2}' invalid ", this.getTagName(), this._ejbRefName, link));
        }
    }

    private Object lookupByForeignJndi(String foreignName, Class type) throws NamingException {
        Object target = Jndi.lookup(foreignName);
        return target;
    }

    private Object lookupLocal(Class type) {
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ejbRefName + ", " + this._ejbLink + ", " + this._foreignName + "]";
    }
}

