/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.types.RawString;
import com.caucho.config.types.ResourceGroupConfig;
import com.caucho.config.types.Validator;
import com.caucho.el.Expr;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.spi.CreationalContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvEntry
extends ResourceGroupConfig
implements Validator {
    private static final L10N L = new L10N(EnvEntry.class);
    private static final Logger log = Logger.getLogger(EnvEntry.class.getName());
    private String _name;
    private Class<?> _type;
    private String _value;
    private Object _objectValue;

    @Override
    public void setId(String id) {
    }

    public void setEnvEntryName(String name) {
        this._name = name;
    }

    public String getEnvEntryName() {
        return this._name;
    }

    public void setEnvEntryType(Class<?> type) {
        this._type = type;
    }

    public Class<?> getEnvEntryType() {
        return this._type;
    }

    public void setEnvEntryValue(RawString value) {
        this._value = value.getValue();
    }

    public String getEnvEntryValue() {
        return this._value;
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        if (this._name == null) {
            throw new ConfigException(L.l("env-entry needs 'env-entry-name' attribute"));
        }
        super.init();
        if (!this.isProgram()) {
            this.deploy();
        }
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) {
    }

    @Override
    public Object getValue() {
        if (this.getLookupName() != null) {
            try {
                return Jndi.lookup(this.getLookupName());
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        if (this._objectValue == null) {
            this.deploy();
        }
        return this._objectValue;
    }

    @Override
    public void deploy() {
        if (this._objectValue != null) {
            return;
        }
        super.deploy();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            try {
                if (this.getJndiClassLoader() != null) {
                    thread.setContextClassLoader(this.getJndiClassLoader());
                }
                Jndi.bindDeepShort(this._name, this);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            Object var5_3 = null;
            thread.setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            thread.setContextClassLoader(loader);
            throw throwable;
        }
        if (this._value == null) {
            return;
        }
        LinkedHashSet<Type> types = new LinkedHashSet<Type>();
        Class<?> type = this._type;
        Constable value = this._value;
        if (type == null) {
            type = this.inferTypeFromInjection();
        }
        if (type != null) {
            types.add(type);
        } else {
            types.add(value.getClass());
        }
        if (this.getLookupName() == null && type != null && !type.equals(String.class)) {
            if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                value = this._value != null ? new Boolean("true".equals(this._value.toLowerCase())) : Boolean.FALSE;
                types.add(Boolean.TYPE);
            } else if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
                value = new Byte((byte)Expr.toLong(this._value, null));
                types.add(Byte.TYPE);
            } else if (Short.class.equals(type) || Short.TYPE.equals(type)) {
                value = new Short((short)Expr.toLong(this._value, null));
                types.add(Short.TYPE);
            } else if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
                value = new Integer((int)Expr.toLong(this._value, null));
                types.add(Integer.TYPE);
            } else if (Long.class.equals(type) || Long.TYPE.equals(type)) {
                value = new Long(Expr.toLong(this._value, null));
                types.add(Long.TYPE);
            } else if (Float.class.equals(type) || Float.TYPE.equals(type)) {
                value = new Float((float)Expr.toDouble(this._value, null));
                types.add(Float.TYPE);
            } else if (Double.class.equals(type) || Double.TYPE.equals(type)) {
                value = new Double(Expr.toDouble(this._value, null));
                types.add(Double.TYPE);
            } else if (Character.class.equals(type) || Character.TYPE.equals(type)) {
                String v = Expr.toString(this._value, null);
                value = v == null || v.length() == 0 ? new Character(' ') : new Character(v.charAt(0));
                types.add(Character.TYPE);
            } else if (Enum.class.isAssignableFrom(type)) {
                value = Enum.valueOf(type, this._value);
            } else if (Class.class.isAssignableFrom(type)) {
                try {
                    loader = Thread.currentThread().getContextClassLoader();
                    value = Class.forName(this._value, false, loader);
                }
                catch (Exception e) {
                    throw ConfigException.create(e);
                }
            }
        }
        this._objectValue = value;
        if (value == null) {
            return;
        }
        InjectManager cdiManager = InjectManager.create();
        BeanBuilder<?> builder = cdiManager.createBeanFactory(value.getClass());
        if (this._name.indexOf(46) < 0) {
            builder.name(this._name);
        }
        builder.qualifier((Annotation)Names.create(this._name));
        builder.qualifier((Annotation)DefaultLiteral.DEFAULT);
        builder.type(types);
        cdiManager.addBean(builder.singleton(value));
    }

    @Override
    public void validate() throws ConfigException {
        Object obj = null;
        try {
            obj = new InitialContext().lookup("java:comp/env/" + this._name);
        }
        catch (NamingException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (obj == null) {
            throw this.error(L.l("env-entry '{0}' was not configured.  All resources defined by <env-entry> tags must be defined in a configuration file.", this._name));
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

