/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ResourceInjectionTargetProgram;
import com.caucho.config.program.ResourceProgram;
import com.caucho.config.types.InjectionTarget;
import com.caucho.naming.Jndi;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.L10N;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.spi.CreationalContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceGroupConfig
extends ConfigProgram
implements ObjectProxy {
    private static final Logger log = Logger.getLogger(ResourceGroupConfig.class.getName());
    private static final L10N L = new L10N(ResourceGroupConfig.class);
    private String _location = "";
    private String _defaultInjectionClass;
    private ArrayList<InjectionTarget> _injectionTargets = new ArrayList();
    private String _lookupName;
    private boolean _isProgram;
    private ClassLoader _jndiClassLoader;

    public void setDefaultInjectionClass(String className) {
        this._defaultInjectionClass = className;
    }

    public void setId(String id) {
    }

    public void setConfigLocation(String filename, int line) {
        this._location = filename + ":" + line + " ";
    }

    public void setDescription(String description) {
    }

    public void addInjectionTarget(InjectionTarget injectionTarget) {
        this._injectionTargets.add(injectionTarget);
    }

    public void setLookupName(String lookupName) {
        this._lookupName = lookupName;
    }

    public String getLookupName() {
        return this._lookupName;
    }

    public void setProgram(boolean isProgram) {
        this._isProgram = isProgram;
    }

    public boolean isProgram() {
        return this._isProgram;
    }

    public void setJndiClassLoader(ClassLoader loader) {
        this._jndiClassLoader = loader;
    }

    public ClassLoader getJndiClassLoader() {
        return this._jndiClassLoader;
    }

    @PostConstruct
    public void init() throws Exception {
        if (!this.isProgram()) {
            this.deploy();
        }
    }

    public void deploy() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        InjectManager cdiManager = InjectManager.getCurrent();
        for (InjectionTarget target : this._injectionTargets) {
            Object var12_13;
            String targetClassName = target.getInjectionTargetClass();
            String targetMethod = target.getInjectionTargetName();
            try {
                try {
                    Class<?> targetClass = Class.forName(targetClassName, false, loader);
                    ResourceInjectionTargetProgram resourceProgram = new ResourceInjectionTargetProgram(this, targetClass, targetMethod);
                    cdiManager.getResourceManager().addResource(resourceProgram);
                    if (this.getJndiClassLoader() != null) {
                        thread.setContextClassLoader(this.getJndiClassLoader());
                    }
                    String jndiName = "java:comp/env/" + targetClassName + "/" + targetMethod;
                    Jndi.bindDeep(jndiName, this);
                }
                catch (ConfigException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ConfigException(L.l("'{0}' is an unknown class in {1}", (Object)targetClassName, this), e);
                }
                var12_13 = null;
                thread.setContextClassLoader(loader);
            }
            catch (Throwable throwable) {
                var12_13 = null;
                thread.setContextClassLoader(loader);
                throw throwable;
            }
        }
    }

    public ConfigProgram getProgram() {
        return new ResourceProgram(this);
    }

    public ConfigProgram getProgram(Class<?> cl) {
        throw new IllegalStateException();
    }

    protected Class<?> inferTypeFromInjection() {
        for (InjectionTarget target : this._injectionTargets) {
            try {
                String className = target.getInjectionTargetClass();
                String name = target.getInjectionTargetName();
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName(className, false, loader);
                Class<?> type = this.findProperty(cl, name);
                if (type == null) continue;
                return type;
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return null;
    }

    private Class<?> findProperty(Class<?> cl, String name) {
        if (cl == null) {
            return null;
        }
        for (Field field : cl.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            return field.getType();
        }
        return null;
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) {
    }

    @Override
    public Object createObject(Hashtable<?, ?> env) throws NamingException {
        Object value = this.getValue();
        return value;
    }

    public Object getValue() {
        return null;
    }

    protected ConfigException error(String msg) {
        if (this._location != null) {
            return new LineConfigException(this._location + msg);
        }
        return new ConfigException(msg);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._location + "]";
    }
}

