/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.IllegalLoopbackException;

public class LockUtil {
    public static void lockRead(Lock readLock, long timeout) {
        try {
            if (!readLock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                throw new ConcurrentAccessTimeoutException("Timed out acquiring read lock.");
            }
        }
        catch (InterruptedException e) {
            throw new ConcurrentAccessTimeoutException("Thread interruption acquiring read lock: " + e.getMessage());
        }
    }

    public static void lockWrite(ReentrantReadWriteLock lock) {
        if (lock.getReadHoldCount() > 0 && lock.getWriteHoldCount() == 0) {
            throw new IllegalLoopbackException("Cannot attempt a nested write lock without an existing write lock.");
        }
        lock.writeLock().lock();
    }

    public static void lockWrite(ReentrantReadWriteLock lock, long timeout) {
        if (lock.getReadHoldCount() > 0 && lock.getWriteHoldCount() == 0) {
            throw new IllegalLoopbackException("Cannot attempt a nested write lock without an existing write lock.");
        }
        try {
            if (!lock.writeLock().tryLock(timeout, TimeUnit.MILLISECONDS)) {
                throw new ConcurrentAccessTimeoutException("Timed out acquiring write lock.");
            }
        }
        catch (InterruptedException e) {
            throw new ConcurrentAccessTimeoutException("Thread interruption acquiring write lock: " + e.getMessage());
        }
    }
}

