/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.xml;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.ServiceStartup;
import com.caucho.config.bytecode.ScopeProxy;
import com.caucho.config.cfg.BeansConfig;
import com.caucho.config.extension.ProcessBeanImpl;
import com.caucho.config.inject.HandleAware;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ScheduleBean;
import com.caucho.config.inject.SingletonHandle;
import com.caucho.config.xml.XmlCookie;
import com.caucho.inject.LazyExtension;
import com.caucho.inject.Module;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import javax.ejb.Startup;
import javax.ejb.Stateless;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class XmlStandardPlugin
implements Extension {
    private static final String SCHEMA = "com/caucho/config/cfg/resin-beans.rnc";
    private InjectManager _cdiManager;
    private HashSet<String> _configuredBeans = new HashSet();
    private ArrayList<Path> _paths = new ArrayList();
    private ArrayList<Path> _pendingPaths = new ArrayList();
    private ArrayList<BeansConfig> _pendingBeans = new ArrayList();
    private ArrayList<Bean<?>> _pendingService = new ArrayList();
    private Throwable _configException;

    public XmlStandardPlugin(InjectManager manager) {
        this._cdiManager = manager;
        Thread.currentThread().getContextClassLoader();
    }

    public void addRoot(Path root) {
        if (!this._paths.contains(root)) {
            this._pendingPaths.add(root);
        }
    }

    public void beforeDiscovery(@Observes BeforeBeanDiscovery event) {
        ArrayList<Path> paths = new ArrayList<Path>(this._pendingPaths);
        this._pendingPaths.clear();
        try {
            for (Path root : paths) {
                this.configureRoot(root);
            }
            for (int i = 0; i < this._pendingBeans.size(); ++i) {
                BeansConfig config = this._pendingBeans.get(i);
                ArrayList<Class<?>> deployList = config.getDeployList();
                if (deployList == null || deployList.size() <= 0) continue;
                this._cdiManager.setDeploymentTypes(deployList);
            }
        }
        catch (Exception e) {
            if (this._configException == null) {
                this._configException = e;
            }
            throw ConfigException.create(e);
        }
    }

    private void configureRoot(Path root) throws IOException {
        this.configurePath(root.lookup("META-INF/beans.xml"));
        this.configurePath(root.lookup("META-INF/resin-beans.xml"));
        if (root.getFullPath().endsWith("WEB-INF/classes/")) {
            this.configurePath(root.lookup("../beans.xml"));
            this.configurePath(root.lookup("../resin-beans.xml"));
        } else if (!root.lookup("META-INF/beans.xml").canRead() && !root.lookup("META-INF/resin-beans.xml").canRead()) {
            this.configurePath(root.lookup("beans.xml"));
            this.configurePath(root.lookup("resin-beans.xml"));
        }
    }

    private void configurePath(Path beansPath) throws IOException {
        if (beansPath.canRead() && beansPath.getLength() > 0L) {
            BeansConfig beans = new BeansConfig(this._cdiManager, beansPath);
            beansPath.setUserPath(beansPath.getURL());
            new Config().configure((Object)beans, beansPath, SCHEMA);
            this._pendingBeans.add(beans);
        }
    }

    public void addConfiguredBean(String className) {
        this._configuredBeans.add(className);
    }

    @LazyExtension
    public void processType(@Observes ProcessAnnotatedType<?> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (type == null) {
            return;
        }
        if (type.isAnnotationPresent(XmlCookie.class)) {
            return;
        }
        if (this._configuredBeans.contains(type.getJavaClass().getName())) {
            event.veto();
            return;
        }
    }

    @LazyExtension
    public void processTarget(@Observes ProcessInjectionTarget<?> event) {
        AnnotatedType type = event.getAnnotatedType();
        XmlCookie cookie = (XmlCookie)type.getAnnotation(XmlCookie.class);
        if (cookie != null) {
            InjectionTarget<?> target = this._cdiManager.getXmlInjectionTarget(cookie.value());
            event.setInjectionTarget(target);
        }
    }

    public void processType(@Observes AfterBeanDiscovery event) {
        if (this._configException != null) {
            event.addDefinitionError(this._configException);
        }
    }

    @LazyExtension
    public void processBean(@Observes ProcessBean<?> event) {
        ProcessBeanImpl eventImpl = (ProcessBeanImpl)event;
        if (eventImpl.getManager() != this._cdiManager) {
            return;
        }
        Annotated annotated = event.getAnnotated();
        Bean bean = event.getBean();
        if (this.isStartup(annotated)) {
            this._pendingService.add(bean);
        }
    }

    public void processAfterValidation(@Observes AfterDeploymentValidation event) {
        ArrayList startupBeans = new ArrayList(this._pendingService);
        this._pendingService.clear();
        for (Bean<?> bean : startupBeans) {
            CreationalContext<?> env = this._cdiManager.createCreationalContext(bean);
            Object value = this._cdiManager.getReference(bean, bean.getBeanClass(), env);
            if (value instanceof ScopeProxy) {
                ((ScopeProxy)value).__caucho_getDelegate();
            }
            if (bean instanceof ScheduleBean) {
                ((ScheduleBean)bean).scheduleTimers(value);
            }
            if (!(value instanceof HandleAware) || !(bean instanceof PassivationCapable)) continue;
            String id = ((PassivationCapable)bean).getId();
            ((HandleAware)value).setSerializationHandle(new SingletonHandle(id));
        }
    }

    private boolean isStartup(Annotated annotated) {
        if (annotated == null) {
            return false;
        }
        for (Annotation ann : annotated.getAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (annType.equals(Stateless.class)) {
                return true;
            }
            if (annType.equals(Startup.class)) {
                return true;
            }
            if (annType.equals(ServiceStartup.class)) {
                return true;
            }
            if (!annType.isAnnotationPresent(Stereotype.class)) continue;
            if (annType.isAnnotationPresent(ServiceStartup.class)) {
                return true;
            }
            if (!annType.isAnnotationPresent(Startup.class)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

