/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.index;

import com.caucho.db.index.KeyCompare;

public class BinaryKeyCompare
extends KeyCompare {
    private final int _length;

    public BinaryKeyCompare(int length) {
        this._length = length;
    }

    public int compare(byte[] keyBuffer, int keyOffset, byte[] block, int offset, int length) {
        int end = this._length;
        for (int i = 0; i < end; ++i) {
            int ch1 = keyBuffer[keyOffset + i] & 0xFF;
            int ch2 = block[offset + i] & 0xFF;
            if (ch1 < ch2) {
                return -1;
            }
            if (ch2 >= ch1) continue;
            return 1;
        }
        return 0;
    }

    public String toString(byte[] buffer, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        int keyLen = this._length;
        for (int j = 0; j < keyLen; ++j) {
            int ch = buffer[offset + j] & 0xFF;
            int d1 = ch >> 4 & 0xF;
            int d2 = ch & 0xF;
            if (d1 < 10) {
                sb.append((char)(48 + d1));
            } else {
                sb.append((char)(97 + d1 - 10));
            }
            if (d2 < 10) {
                sb.append((char)(48 + d2));
                continue;
            }
            sb.append((char)(97 + d2 - 10));
        }
        return sb.toString();
    }
}

