/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.lock;

import com.caucho.db.lock.LockTimeoutException;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Lock {
    private static final L10N L = new L10N(Lock.class);
    private static final Logger log = Logger.getLogger(Lock.class.getName());
    private static final AtomicLongFieldUpdater<Lock> _lockCountUpdater = AtomicLongFieldUpdater.newUpdater(Lock.class, "_lockCount");
    private static final AtomicReferenceFieldUpdater<Lock, LockNode> _headUpdater = AtomicReferenceFieldUpdater.newUpdater(Lock.class, LockNode.class, "_lockHead");
    private static final AtomicReferenceFieldUpdater<LockNode, LockNode> _nextUpdater = AtomicReferenceFieldUpdater.newUpdater(LockNode.class, LockNode.class, "_next");
    private static final long NODE_LOCK = 0x100000000L;
    private static final long NODE_LOCK_MASK = -4294967296L;
    private static final long READ = 1L;
    private static final long READ_MASK = 0xFFFFFFFFL;
    private final String _id;
    private volatile long _lockCount;
    private volatile LockNode _lockHead;

    public Lock(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void lockRead(long timeout) throws LockTimeoutException {
        long lock;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " lockRead 0x" + Long.toHexString(this._lockCount));
        }
        while ((lock = this._lockCount) < 0x100000000L) {
            if (!_lockCountUpdater.compareAndSet(this, lock, lock + 1L)) continue;
            return;
        }
        this.addReadLock(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReadLock(long timeout) {
        long nextLock2;
        long lock;
        LockNode head;
        long expires = Alarm.getCurrentTimeActual() + timeout;
        LockNode node = new LockNode(true);
        do {
            head = this._lockHead;
            node.setNext(head);
        } while (!_headUpdater.compareAndSet(this, head, node));
        while (!_lockCountUpdater.compareAndSet(this, lock = this._lockCount, lock + 0x100000000L)) {
        }
        try {
            node.park(expires);
            Object var10_6 = null;
        }
        catch (Throwable throwable) {
            long nextLock2;
            Object var10_7 = null;
            while (!_lockCountUpdater.compareAndSet(this, lock = this._lockCount, nextLock2 = lock - 0x100000000L + 1L)) {
            }
            LockNode next = node.getNext();
            if (next != null) {
                next.unpark();
            }
            throw throwable;
        }
        while (!_lockCountUpdater.compareAndSet(this, lock = this._lockCount, nextLock2 = lock - 0x100000000L + 1L)) {
        }
        LockNode next = node.getNext();
        if (next != null) {
            next.unpark();
        }
    }

    public void unlockRead() {
        LockNode node;
        long lock;
        while (!_lockCountUpdater.compareAndSet(this, lock = this._lockCount, lock - 1L)) {
        }
        if ((lock & 0xFFFFFFFFL) == 1L && (lock & 0xFFFFFFFF00000000L) != 0L && (node = this.popNextNode()) != null) {
            node.unpark();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lockReadAndWrite(long timeout) {
        long lock;
        LockNode head;
        long expires = Alarm.getCurrentTimeActual() + timeout;
        LockNode node = new LockNode(false);
        do {
            head = this._lockHead;
            node.setNext(head);
        } while (!_headUpdater.compareAndSet(this, head, node));
        while (!_lockCountUpdater.compareAndSet(this, lock = this._lockCount, lock + 0x100000000L)) {
        }
        if (lock == 0L) {
            LockNode popNode = this.popNextNode();
            assert (node == popNode);
            return;
        }
        boolean isValid = false;
        try {
            node.park(expires);
            return;
        }
        catch (Throwable throwable) {
            long nextLock;
            Object var11_9 = null;
            if (isValid) throw throwable;
            while (!_lockCountUpdater.compareAndSet(this, lock = this._lockCount, nextLock = lock - 0x100000000L)) {
            }
            throw throwable;
        }
    }

    public void unlockReadAndWrite() {
        long lock;
        while (!_lockCountUpdater.compareAndSet(this, lock = this._lockCount, lock - 0x100000000L)) {
        }
        LockNode node = this.popNextNode();
        if (node != null) {
            node.unpark();
        }
    }

    public boolean lockReadAndWriteNoWait() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " lockReadAndWriteNoWait " + "0x" + Long.toHexString(this._lockCount));
        }
        return _lockCountUpdater.compareAndSet(this, 0L, 0x100000000L);
    }

    void waitForCommit() {
    }

    private LockNode popNextNode() {
        LockNode firstPrev;
        LockNode first;
        LockNode head;
        do {
            if ((head = this._lockHead) == null) {
                return null;
            }
            first = null;
            firstPrev = null;
            LockNode ptrPrev = null;
            for (LockNode ptr = head; ptr != null; ptr = ptr.getNext()) {
                if (first == null || !ptr.isRead() || !first.isRead()) {
                    first = ptr;
                    firstPrev = ptrPrev;
                }
                ptrPrev = ptr;
            }
        } while (!(head == first ? _headUpdater.compareAndSet(this, head, null) : _nextUpdater.compareAndSet(firstPrev, first, null)));
        return first;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }

    static final class LockNode {
        private final Thread _thread = Thread.currentThread();
        private final boolean _isRead;
        public volatile LockNode _next;
        private volatile boolean _isDead;
        private volatile boolean _isWake;

        LockNode(boolean isRead) {
            this._isRead = isRead;
        }

        LockNode getNext() {
            return this._next;
        }

        void setNext(LockNode next) {
            this._next = next;
        }

        boolean isRead() {
            return this._isRead;
        }

        public void park(long expires) {
            while (!this._isWake) {
                try {
                    Thread.interrupted();
                    LockSupport.parkUntil(expires);
                    if (this._isWake || expires >= Alarm.getCurrentTimeActual()) continue;
                    this._isDead = true;
                    throw new LockTimeoutException();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void unpark() {
            this._isWake = true;
            LockSupport.unpark(this._thread);
        }
    }
}

