/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.AbstractBinaryExpr;
import com.caucho.db.sql.DoubleEqExpr;
import com.caucho.db.sql.DoubleGeExpr;
import com.caucho.db.sql.DoubleGtExpr;
import com.caucho.db.sql.DoubleLeExpr;
import com.caucho.db.sql.DoubleLeNonNullExpr;
import com.caucho.db.sql.DoubleLtExpr;
import com.caucho.db.sql.DoubleLtNonNullExpr;
import com.caucho.db.sql.DoubleNeqExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CmpExpr
extends AbstractBinaryExpr {
    private Expr _left;
    private Expr _right;
    private int _op;

    CmpExpr(Expr left, Expr right, int op) {
        this._left = left;
        this._right = right;
        this._op = op;
    }

    @Override
    public final Expr getLeft() {
        return this._left;
    }

    @Override
    public final Expr getRight() {
        return this._right;
    }

    @Override
    public Expr create(Expr left, Expr right) {
        return new CmpExpr(left, right, this._op);
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        this._left = this._left.bind(query);
        this._right = this._right.bind(query);
        switch (this._op) {
            case 157: {
                if (this._left.isNullable() || this._right.isNullable()) {
                    return new DoubleLtExpr(this._left, this._right);
                }
                return new DoubleLtNonNullExpr(this._left, this._right);
            }
            case 158: {
                if (this._left.isNullable() || this._right.isNullable()) {
                    return new DoubleLeExpr(this._left, this._right);
                }
                return new DoubleLeNonNullExpr(this._left, this._right);
            }
            case 159: {
                return new DoubleGtExpr(this._left, this._right);
            }
            case 160: {
                return new DoubleGeExpr(this._left, this._right);
            }
        }
        if (this._left.isDouble() || this._right.isDouble()) {
            switch (this._op) {
                case 155: {
                    return new DoubleEqExpr(this._left, this._right);
                }
                case 156: {
                    return new DoubleNeqExpr(this._left, this._right);
                }
            }
        }
        return this;
    }

    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        if (this._left.isNull(context) || this._right.isNull(context)) {
            return -1;
        }
        switch (this._op) {
            case 156: {
                String leftValue = this._left.evalString(context);
                String rightValue = this._right.evalString(context);
                if (!(leftValue == rightValue || leftValue != null && leftValue.equals(rightValue))) {
                    return 1;
                }
                return 0;
            }
            case 155: {
                String leftValue = this._left.evalString(context);
                String rightValue = this._right.evalString(context);
                if (leftValue == rightValue || leftValue != null && leftValue.equals(rightValue)) {
                    return 1;
                }
                return 0;
            }
        }
        throw new SQLException("can't compare");
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        throw new SQLException("can't convert string to boolean");
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._left.evalGroup(context);
        this._right.evalGroup(context);
    }

    public String toString() {
        switch (this._op) {
            case 155: {
                return "(" + this._left + " = " + this._right + ")";
            }
            case 156: {
                return "(" + this._left + " <> " + this._right + ")";
            }
            case 157: {
                return "(" + this._left + " < " + this._right + ")";
            }
            case 158: {
                return "(" + this._left + " <= " + this._right + ")";
            }
            case 159: {
                return "(" + this._left + " > " + this._right + ")";
            }
            case 160: {
                return "(" + this._left + " >= " + this._right + ")";
            }
        }
        return "(" + this._left + " =? " + this._right + ")";
    }
}

