/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OidExpr
extends Expr {
    private Table _table;
    private int _tableIndex;
    private FromItem _fromItem;

    OidExpr(FromItem fromItem, Table table, int tableIndex) {
        this._fromItem = fromItem;
        this._table = table;
        this._tableIndex = tableIndex;
    }

    FromItem getFromItem() {
        return this._fromItem;
    }

    @Override
    public Class<?> getType() {
        return Long.TYPE;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public String getName() {
        return "resin_oid";
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    @Override
    public Expr bind(Query query) {
        FromItem[] fromItems = query.getFromItems();
        for (int i = 0; i < fromItems.length; ++i) {
            if (fromItems[i] != this._fromItem) continue;
            this._tableIndex = i;
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return false;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return String.valueOf(row.getRowAddress());
    }

    public int evalInt(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return (int)row.getRowAddress();
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getRowAddress();
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getRowAddress();
    }

    @Override
    public void evalToResult(QueryContext context, SelectResult result) {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        result.writeLong(row.getRowAddress());
    }

    public String toString() {
        return "OidExpr[" + this._tableIndex + "]";
    }
}

