/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParamExpr
extends Expr {
    private static final int NULL = 0;
    private static final int BOOLEAN = 1;
    private static final int STRING = 2;
    private static final int LONG = 3;
    private static final int DOUBLE = 4;
    private static final int DATE = 5;
    private static final int BINARY = 6;
    private static final int BYTES = 7;
    private final int _index;

    ParamExpr(int index) {
        this._index = index + 1;
    }

    @Override
    public Class<?> getType() {
        return Object.class;
    }

    @Override
    public boolean isParam() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return 0L;
    }

    public void clear() {
    }

    @Override
    public boolean isBinaryStream(QueryContext context) {
        return context.isBinaryStream(this._index);
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return context.isNull(this._index);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return context.getString(this._index);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        return context.getBoolean(this._index);
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        return context.getLong(this._index);
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return context.getDouble(this._index);
    }

    @Override
    public long evalDate(QueryContext context) throws SQLException {
        return context.getDate(this._index);
    }

    @Override
    public byte[] evalBytes(QueryContext context) throws SQLException {
        return context.getBytes(this._index);
    }

    @Override
    public InputStream evalStream(QueryContext context) {
        return context.getBinaryStream(this._index);
    }

    @Override
    public int evalToBuffer(QueryContext context, byte[] buffer, int offset) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return "?" + this._index;
    }
}

