/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnaryExpr
extends Expr {
    private Expr _sub;
    private int _op;

    UnaryExpr(Expr sub, int op) {
        this._sub = sub;
        this._op = op;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        Expr newSub = this._sub.bind(query);
        switch (this._op) {
            case 45: {
                if (newSub.isDouble()) break;
                throw new SQLException(L.l("unary minus requires a numeric expression at '{0}'", newSub));
            }
        }
        if (newSub == this._sub) {
            return this;
        }
        return new UnaryExpr(newSub, this._op);
    }

    public Class getType() {
        switch (this._op) {
            case 45: {
                if (this._sub.isLong()) {
                    return Long.TYPE;
                }
                return Double.TYPE;
            }
        }
        return Object.class;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._sub.subCost(fromList);
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this._sub.isNull(context);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        switch (this._op) {
            default: 
        }
        throw new IllegalStateException();
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        switch (this._op) {
            case 45: {
                return -this._sub.evalLong(context);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        switch (this._op) {
            case 45: {
                return -this._sub.evalDouble(context);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        switch (this._op) {
            case 45: {
                if (this.isLong()) {
                    return String.valueOf(this.evalLong(context));
                }
                return String.valueOf(this.evalDouble(context));
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._sub.evalGroup(context);
    }

    public String toString() {
        switch (this._op) {
            case 45: {
                return "- " + this._sub;
            }
        }
        throw new IllegalStateException("can't compare:" + this._op);
    }
}

