/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.Transaction;
import com.caucho.inject.Module;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.SQLException;

@Module
public class UniqueConstraint
extends Constraint {
    private static final L10N L = new L10N(UniqueConstraint.class);
    private final Column[] _uniqueSet;

    public UniqueConstraint(Column[] uniqueSet) {
        this._uniqueSet = uniqueSet;
    }

    public void validate(TableIterator[] sourceRows, QueryContext queryContext, Transaction xa) throws SQLException {
        TableIterator sourceRow = sourceRows[0];
        Table table = sourceRow.getTable();
        TableIterator iter = table.createTableIterator();
        byte[] sourceBuffer = sourceRow.getBuffer();
        int sourceOffset = sourceRow.getRowOffset();
        iter.init(queryContext);
        try {
            while (iter.next()) {
                byte[] iterBuffer = iter.getBuffer();
                iter.prevRow();
                while (iter.nextRow()) {
                    int iterOffset = iter.getRowOffset();
                    if (iterBuffer == sourceBuffer && iterOffset == sourceOffset) continue;
                    boolean isMatch = true;
                    for (int i = 0; i < this._uniqueSet.length; ++i) {
                        Column column = this._uniqueSet[i];
                        if (column.isEqual(iterBuffer, iterOffset, sourceBuffer, sourceOffset)) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch) continue;
                    long blockId = iter.getBlockId();
                    throw new SQLException(L.l("'{0}' in {1}.{2} fails uniqueness constraint.", this._uniqueSet[0].getString(blockId, iterBuffer, iterOffset), table.getName(), this._uniqueSet[0].getName()));
                }
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }
}

