/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.distcache;

import com.caucho.config.Configurable;
import com.caucho.distcache.AbstractCache;
import com.caucho.distcache.ClusterCache;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
@Configurable
public class CacheManager {
    private ConcurrentHashMap<String, AbstractCache> _cacheMap = new ConcurrentHashMap();

    public AbstractCache get(String name) {
        return this._cacheMap.get(name);
    }

    public AbstractCache create(String name) {
        AbstractCache cache = this._cacheMap.get(name);
        if (cache == null) {
            cache = new ClusterCache(name);
            cache.init();
            this._cacheMap.putIfAbsent(name, cache);
        }
        return this._cacheMap.get(name);
    }

    public AbstractCache putIfAbsent(String name, AbstractCache cache) {
        return this._cacheMap.putIfAbsent(name, cache);
    }

    public void remove(String name) {
        this._cacheMap.remove(name);
    }
}

