/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.distcache;

import com.caucho.distcache.CacheSerializer;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianDebugOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HessianSerializer
implements CacheSerializer {
    private static final Logger log = Logger.getLogger(HessianSerializer.class.getName());

    public void serialize(Object value, OutputStream os) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            os = new HessianDebugOutputStream(os, log, Level.FINEST);
        }
        Hessian2Output hOut = new Hessian2Output(os);
        hOut.writeObject(value);
        hOut.close();
    }

    public Object deserialize(InputStream is) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            is = new HessianDebugInputStream(is, log, Level.FINEST);
        }
        Hessian2Input hIn = new Hessian2Input(is);
        Object value = hIn.readObject();
        hIn.close();
        return value;
    }
}

