/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.ApplicationExceptionConfig;
import com.caucho.config.types.FileSetType;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbBeanConfigProxy;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.cfg.EjbMessageBean;
import com.caucho.ejb.cfg.EjbSingletonBean;
import com.caucho.ejb.cfg.EjbStatefulBean;
import com.caucho.ejb.cfg.EjbStatelessBean;
import com.caucho.ejb.cfg.FunctionSignature;
import com.caucho.ejb.cfg.Interceptor;
import com.caucho.ejb.cfg.InterceptorBinding;
import com.caucho.ejb.cfg.MessageDestination;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.ejb.util.AppExceptionItem;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.jms.JmsMessageListener;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.ApplicationException;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbConfig {
    private static final L10N L = new L10N(EjbConfig.class);
    protected final EjbManager _ejbContainer;
    private ArrayList<FileSetType> _fileSetList = new ArrayList();
    private HashMap<String, EjbBean<?>> _cfgBeans = new HashMap();
    private HashSet<Class<?>> _beanSet = new HashSet();
    private ArrayList<EjbBean<?>> _pendingBeans = new ArrayList();
    private ArrayList<EjbBean<?>> _deployingBeans = new ArrayList();
    private ArrayList<EjbBeanConfigProxy> _proxyList = new ArrayList();
    private ArrayList<FunctionSignature> _functions = new ArrayList();
    private HashMap<String, MessageDestination> _messageDestinations;
    private ArrayList<Interceptor> _cfgInterceptors = new ArrayList();
    private ArrayList<InterceptorBinding> _cfgInterceptorBindings = new ArrayList();
    private HashMap<Class<?>, ApplicationExceptionConfig> _appExceptionConfig = new HashMap();
    private ConcurrentHashMap<Class<?>, AppExceptionItem> _appExceptionMap = new ConcurrentHashMap();

    public EjbConfig(EjbManager ejbContainer) {
        this._ejbContainer = ejbContainer;
    }

    public void addEjbPath(Path path) throws ConfigException {
        throw new UnsupportedOperationException();
    }

    public void addConfigProxy(EjbBeanConfigProxy proxy) {
        this._proxyList.add(proxy);
        this._beanSet.add(proxy.getEjbClass());
    }

    public String getSchema() {
        return "com/caucho/ejb/cfg/resin-ejb.rnc";
    }

    public EjbManager getEjbContainer() {
        return this._ejbContainer;
    }

    public EjbBean<?> getBeanConfig(String name) {
        assert (name != null);
        return this._cfgBeans.get(name);
    }

    public void setBeanConfig(String name, EjbBean<?> bean) {
        if (name == null || bean == null) {
            throw new NullPointerException();
        }
        EjbBean<?> oldBean = this._cfgBeans.get(name);
        if (oldBean == bean) {
            return;
        }
        if (oldBean != null) {
            throw new IllegalStateException(L.l("{0}: duplicate bean '{1}' old ejb-class={2} new ejb-class={3}", this, name, oldBean, bean));
        }
        this._pendingBeans.add(bean);
        this._cfgBeans.put(name, bean);
        this._beanSet.add(bean.getEJBClass());
    }

    public Interceptor getInterceptor(String className) {
        assert (className != null);
        for (Interceptor interceptor : this._cfgInterceptors) {
            if (!interceptor.getInterceptorClass().equals(className)) continue;
            return interceptor;
        }
        return null;
    }

    public void addInterceptor(Interceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException();
        }
        this._cfgInterceptors.add(interceptor);
    }

    public ArrayList<InterceptorBinding> getInterceptorBinding(String ejbName, boolean isExcludeDefault) {
        assert (ejbName != null);
        ArrayList<InterceptorBinding> bindings = new ArrayList<InterceptorBinding>();
        for (InterceptorBinding binding : this._cfgInterceptorBindings) {
            if (binding.getEjbName().equals(ejbName)) {
                bindings.add(binding);
                continue;
            }
            if (!binding.getEjbName().equals("*") || isExcludeDefault) continue;
            bindings.add(binding);
        }
        return bindings;
    }

    public void addApplicationException(ApplicationExceptionConfig applicationException) {
        Class<?> appExnClass = applicationException.getExceptionClass();
        this._appExceptionConfig.put(appExnClass, applicationException);
    }

    public AppExceptionItem getApplicationException(Class<?> exn, boolean isSystem) {
        AppExceptionItem appExn = this._appExceptionMap.get(exn);
        if (appExn == null) {
            appExn = this.createApplicationException(exn, isSystem);
            this._appExceptionMap.put(exn, appExn);
        }
        return appExn;
    }

    private AppExceptionItem createApplicationException(Class<?> exn, boolean isSystem) {
        if (exn == Error.class || exn == RuntimeException.class) {
            return new AppExceptionItem(true, true, true);
        }
        if (exn == Exception.class) {
            return new AppExceptionItem(false, false, true);
        }
        ApplicationExceptionConfig cfg = this._appExceptionConfig.get(exn);
        if (cfg != null) {
            return new AppExceptionItem(true, cfg.isRollback(), cfg.isInherited());
        }
        ApplicationException appExn = exn.getAnnotation(ApplicationException.class);
        if (appExn != null) {
            return new AppExceptionItem(true, appExn.rollback(), true);
        }
        AppExceptionItem parentItem = this.getApplicationException(exn.getSuperclass(), isSystem);
        if (parentItem.isInherited()) {
            return parentItem;
        }
        if (isSystem) {
            return new AppExceptionItem(true, true, true);
        }
        return new AppExceptionItem(false, false, true);
    }

    public void addInterceptorBinding(InterceptorBinding interceptorBinding) {
        this._cfgInterceptorBindings.add(interceptorBinding);
    }

    public void addMessageDestination(MessageDestination messageDestination) {
        if (this._messageDestinations == null) {
            this._messageDestinations = new HashMap();
        }
        String name = messageDestination.getMessageDestinationName();
        this._messageDestinations.put(name, messageDestination);
    }

    public MessageDestination getMessageDestination(String name) {
        if (this._messageDestinations == null) {
            return null;
        }
        return this._messageDestinations.get(name);
    }

    public boolean isConfiguredBean(Class<?> beanType) {
        return this._beanSet.contains(beanType);
    }

    public <X> void addAnnotatedType(AnnotatedType<X> rawAnnType, AnnotatedType<X> annType, InjectionTarget<X> injectTarget, String moduleName) {
        try {
            Class type = annType.getJavaClass();
            if (this.findBeanByType(type) != null) {
                return;
            }
            if (annType.isAnnotationPresent(Stateless.class)) {
                EjbStatelessBean<X> bean = new EjbStatelessBean<X>(this, rawAnnType, annType, moduleName);
                bean.setInjectionTarget(injectTarget);
                Stateless stateless = (Stateless)annType.getAnnotation(Stateless.class);
                if (!"".equals(stateless.name()) && stateless.name() != null) {
                    bean.setEJBName(stateless.name());
                }
                this.setBeanConfig(bean.getEJBName(), bean);
            } else if (annType.isAnnotationPresent(Stateful.class)) {
                EjbStatefulBean<X> bean = new EjbStatefulBean<X>(this, rawAnnType, annType, moduleName);
                bean.setInjectionTarget(injectTarget);
                Stateful stateful = (Stateful)annType.getAnnotation(Stateful.class);
                if (!"".equals(stateful.name()) && stateful.name() != null) {
                    bean.setEJBName(stateful.name());
                }
                this.setBeanConfig(bean.getEJBName(), bean);
            } else if (annType.isAnnotationPresent(Singleton.class)) {
                EjbSingletonBean<X> bean = new EjbSingletonBean<X>(this, rawAnnType, annType, moduleName);
                bean.setInjectionTarget(injectTarget);
                Singleton singleton = (Singleton)annType.getAnnotation(Singleton.class);
                if (!"".equals(singleton.name()) && singleton.name() != null) {
                    bean.setEJBName(singleton.name());
                }
                this.setBeanConfig(bean.getEJBName(), bean);
            } else if (annType.isAnnotationPresent(MessageDriven.class)) {
                EjbMessageBean<X> bean = new EjbMessageBean<X>(this, rawAnnType, annType, moduleName);
                bean.setInjectionTarget(injectTarget);
                this.setBeanConfig(bean.getEJBName(), bean);
            } else if (annType.isAnnotationPresent(JmsMessageListener.class)) {
                JmsMessageListener listener = (JmsMessageListener)annType.getAnnotation(JmsMessageListener.class);
                EjbMessageBean<X> bean = new EjbMessageBean<X>(this, rawAnnType, annType, listener.destination());
                bean.setInjectionTarget(injectTarget);
                this.setBeanConfig(bean.getEJBName(), bean);
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public <X> EjbBean<X> findBeanByType(Class<X> type) {
        for (EjbBean<?> bean : this._cfgBeans.values()) {
            Class<?> cl = bean.getEJBClass();
            if (cl == null || !cl.getName().equals(type.getName())) continue;
            return bean;
        }
        return null;
    }

    public void addFunction(FunctionSignature sig, String sql) {
        this._functions.add(sig);
    }

    public ArrayList<FunctionSignature> getFunctions() {
        return this._functions;
    }

    public void configure() throws ConfigException {
        this.findConfigurationFiles();
        try {
            for (EjbBeanConfigProxy configProxy : this._proxyList) {
                configProxy.configure();
            }
            this._proxyList.clear();
            ArrayList beanConfig = new ArrayList(this._pendingBeans);
            this._pendingBeans.clear();
            this._deployingBeans.addAll(beanConfig);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private void findConfigurationFiles() throws ConfigException {
        for (FileSetType fileSet : this._fileSetList) {
            for (Path path : fileSet.getPaths()) {
                this.addEjbPath(path);
            }
        }
    }

    public void deploy() throws ConfigException {
        try {
            EnvironmentClassLoader parentLoader = this._ejbContainer.getClassLoader();
            Path workDir = this._ejbContainer.getWorkDir();
            JavaClassGenerator javaGen = new JavaClassGenerator();
            javaGen.setWorkDir(workDir);
            javaGen.setParentLoader(parentLoader);
            ArrayList deployingBeans = new ArrayList(this._deployingBeans);
            this._deployingBeans.clear();
            this.deployBeans(deployingBeans, javaGen);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployBeans(ArrayList<EjbBean<?>> beanConfig, JavaClassGenerator javaGen) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._ejbContainer.getClassLoader());
            ArrayList beanList = new ArrayList();
            for (EjbBean<?> bean : beanConfig) {
                if (beanList.contains(bean)) continue;
                bean.init();
                this.deployBean(beanConfig, javaGen, beanList, bean);
            }
            Object var9_8 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private <X> void deployBean(ArrayList<EjbBean<?>> beanConfig, JavaClassGenerator javaGen, ArrayList<EjbBean<?>> beanList, EjbBean<X> bean) throws Exception {
        Thread thread = Thread.currentThread();
        EjbLazyGenerator lazyGenerator = new EjbLazyGenerator(bean.getAnnotatedType(), javaGen, bean.getLocalList(), bean.getLocalBean(), bean.getRemoteList());
        AbstractEjbBeanManager server = this.initBean(bean, lazyGenerator);
        this._ejbContainer.addServer(server);
        ArrayList<String> dependList = bean.getBeanDependList();
        for (String depend : dependList) {
            for (EjbBean<?> b : beanConfig) {
                if (bean == b || !depend.equals(b.getEJBName())) continue;
                beanList.add(b);
                thread.setContextClassLoader(server.getClassLoader());
            }
        }
    }

    private <X> AbstractEjbBeanManager<X> initBean(EjbBean<X> bean, EjbLazyGenerator<X> lazyGenerator) throws Exception {
        AbstractEjbBeanManager<X> server = bean.deployServer(this._ejbContainer, lazyGenerator);
        server.init();
        return server;
    }

    public String toString() {
        String id = this._ejbContainer.getClassLoader().getId();
        return this.getClass().getSimpleName() + "[" + id + "]";
    }
}

