/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.reflect.AnnotatedTypeImpl;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbBeanConfigProxy;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbSingletonBean;
import com.caucho.ejb.cfg.EjbStatefulBean;
import com.caucho.ejb.cfg.EjbStatelessBean;
import com.caucho.ejb.cfg.SingletonLiteral;
import com.caucho.ejb.cfg.StatefulLiteral;
import com.caucho.ejb.cfg.StatelessLiteral;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbSessionConfigProxy
extends EjbBeanConfigProxy {
    private static final L10N L = new L10N(EjbSessionConfigProxy.class);
    private String _sessionType;

    public EjbSessionConfigProxy(EjbConfig config, String ejbModuleName) {
        super(config, ejbModuleName);
    }

    public void setSessionType(String sessionType) {
        if ("Stateless".equals(sessionType)) {
            this._sessionType = sessionType;
        } else if ("Stateful".equals(sessionType)) {
            this._sessionType = sessionType;
        } else if ("Singleton".equals(sessionType)) {
            this._sessionType = sessionType;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown sessionType", sessionType));
        }
    }

    @Override
    public void configure() {
        EjbBean<?> ejbBean = this.getConfig().getBeanConfig(this.getEjbName());
        if (ejbBean == null) {
            if (this.getEjbClass() == null) {
                throw new ConfigException(L.l("'{0}' is an unknown EJB name", this.getEjbName()));
            }
            ejbBean = this.createEjbBean(this.getEjbClass());
            if (this.getEjbName() != null) {
                ejbBean.setEJBName(this.getEjbName());
            }
            this.getConfig().setBeanConfig(this.getEjbName(), ejbBean);
        }
        this.getBuilderProgram().configure(ejbBean);
    }

    private <T> EjbBean<T> createEjbBean(Class<T> ejbClass) {
        ReflectionAnnotatedType<T> rawAnnType = ReflectionAnnotatedFactory.introspectType(ejbClass);
        AnnotatedTypeImpl<T> annType = AnnotatedTypeImpl.create(rawAnnType);
        String name = this.getEjbName();
        String description = null;
        String mappedName = null;
        if ("Stateless".equals(this._sessionType)) {
            StatelessLiteral stateless = new StatelessLiteral(name, mappedName, description);
            annType.addAnnotation((Annotation)((Object)stateless));
            return new EjbStatelessBean<T>(this.getConfig(), rawAnnType, annType, stateless.name());
        }
        if ("Stateful".equals(this._sessionType)) {
            StatefulLiteral stateful = new StatefulLiteral(name, mappedName, description);
            annType.addAnnotation((Annotation)((Object)stateful));
            return new EjbStatefulBean<T>(this.getConfig(), rawAnnType, annType, stateful.name());
        }
        if ("Singleton".equals(this._sessionType)) {
            SingletonLiteral singleton = new SingletonLiteral(name, mappedName, description);
            annType.addAnnotation((Annotation)((Object)singleton));
            return new EjbSingletonBean<T>(this.getConfig(), rawAnnType, annType, singleton.name());
        }
        throw new ConfigException(L.l("'{0}' is an unknown <session-type>", this._sessionType));
    }
}

