/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Date;

public class FunctionSignature {
    static L10N L = new L10N(FunctionSignature.class);
    private String _signature;
    private String _name;
    private Class[] _parameterTypes;
    private Class _returnType;
    private int _index;
    private String _sql;

    public FunctionSignature(String signature) throws ConfigException {
        this._signature = signature;
        this.parseSignature();
    }

    public String getName() {
        return this._name;
    }

    public String getSignature() {
        return this._signature;
    }

    public Class[] getParameterTypes() {
        return this._parameterTypes;
    }

    public Class getReturnType() {
        return this._returnType;
    }

    public void setSQL(String sql) {
        this._sql = sql;
    }

    public String getSQL() {
        return this._sql;
    }

    private void parseSignature() throws ConfigException {
        this._index = 0;
        this._returnType = this.parseType(this.skipWhitespace(this.read()));
        CharBuffer cb = CharBuffer.allocate();
        int ch = this.skipWhitespace(this.read());
        while (Character.isJavaIdentifierPart((char)ch)) {
            cb.append((char)ch);
            ch = this.read();
        }
        if (cb.length() == 0) {
            throw new ConfigException(L.l("unexpected empty function name in '{0}'", this._signature));
        }
        this._name = cb.toString();
        if ((ch = this.skipWhitespace(ch)) != 40) {
            throw new ConfigException(L.l("function syntax is 'ret-type name(arg1, ..., argn)' in '{0}'", this._signature));
        }
        ArrayList<Class> argList = new ArrayList<Class>();
        ch = this.read();
        while (Character.isJavaIdentifierStart((char)(ch = this.skipWhitespace(ch)))) {
            Class type = this.parseType(ch);
            argList.add(type);
            ch = this.skipWhitespace(this.read());
            if (ch != 44) continue;
            ch = this.read();
        }
        this._parameterTypes = argList.toArray(new Class[argList.size()]);
        if (ch != 41) {
            throw new ConfigException(L.l("function syntax is 'ret-type name(arg1, ..., argn)' in '{0}'", this._signature));
        }
        ch = this.skipWhitespace(this.read());
        if (ch != -1) {
            throw new ConfigException(L.l("function syntax is 'ret-type name(arg1, ..., argn)' in '{0}'", this._signature));
        }
    }

    private Class parseType(int ch) throws ConfigException {
        CharBuffer cb = CharBuffer.allocate();
        while (Character.isJavaIdentifierPart((char)ch)) {
            cb.append((char)ch);
            ch = this.read();
        }
        if (cb.length() == 0) {
            throw new ConfigException(L.l("unexpected empty type in '{0}'", this._signature));
        }
        String className = cb.toString();
        this.unread(ch);
        return this.findClass(className);
    }

    private Class findClass(String className) throws ConfigException {
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if ("String".equals(className)) {
            return String.class;
        }
        if ("Date".equals(className)) {
            return Date.class;
        }
        if ("any".equals(className)) {
            return Object.class;
        }
        throw new ConfigException(L.l("unknown type '{0}' in '{1}'", (Object)className, this._signature));
    }

    private int skipWhitespace(int ch) {
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        return ch;
    }

    private int read() {
        if (this._index < this._signature.length()) {
            return this._signature.charAt(this._index++);
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._index;
        }
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FunctionSignature)) {
            return false;
        }
        FunctionSignature sig = (FunctionSignature)o;
        if (!this._name.equalsIgnoreCase(sig._name)) {
            return false;
        }
        if (this._parameterTypes.length != sig._parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < this._parameterTypes.length; ++i) {
            if (this._parameterTypes[i].equals(sig._parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Function[" + this._signature + "]";
    }
}

