/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.embeddable;

import com.caucho.ejb.embeddable.EJBContainerImpl;
import com.caucho.java.WorkDir;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xml.stream.XMLStreamReaderImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerProvider
implements javax.ejb.spi.EJBContainerProvider {
    public static final String WORK_DIR = "com.caucho.ejb.embeddable.workDir";
    private static final Logger log = Logger.getLogger(EJBContainerProvider.class.getName());

    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        EJBContainerImpl container = null;
        if (properties == null) {
            container = new EJBContainerImpl();
            this.addModulesFromClasspath(container, null);
            this.setWorkDir();
        } else {
            String provider = (String)properties.get("javax.ejb.embeddable.provider");
            if (provider != null && !EJBContainerImpl.class.getName().equals(provider)) {
                return null;
            }
            String name = (String)properties.get("javax.ejb.embeddable.appName");
            container = new EJBContainerImpl(name);
            this.addModules(container, properties.get("javax.ejb.embeddable.modules"));
            this.setWorkDir(properties.get(WORK_DIR));
        }
        container.start();
        return container;
    }

    private String scanEjbJarXml(Path ejbJarXml) {
        try {
            XMLStreamReaderImpl reader = new XMLStreamReaderImpl(ejbJarXml.openRead());
            while (reader.hasNext()) {
                if (reader.next() != 1 || !"module-name".equals(reader.getLocalName())) continue;
                return reader.getElementText();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (XMLStreamException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return null;
    }

    private String getModuleName(String classpathComponent) {
        String ejbJarModuleName;
        Path ejbJarXml;
        Path path = Vfs.lookup(classpathComponent);
        String tail = path.getTail();
        String moduleName = classpathComponent;
        if (classpathComponent.endsWith(".jar") || classpathComponent.endsWith(".war")) {
            moduleName = tail.substring(0, tail.length() - ".jar".length());
            path = JarPath.create(path);
        }
        if ((ejbJarXml = path.lookup("META-INF/ejb-jar.xml")).canRead() && (ejbJarModuleName = this.scanEjbJarXml(ejbJarXml)) != null) {
            moduleName = ejbJarModuleName;
        }
        return moduleName;
    }

    private void addModulesFromClasspath(EJBContainerImpl container, Set<String> modules) {
        String[] components;
        String classpath = System.getProperty("java.class.path");
        for (String component : components = classpath.split(System.getProperty("path.separator"))) {
            String moduleName = this.getModuleName(component);
            if (moduleName.equals("") || modules != null && !modules.contains(moduleName)) continue;
            container.addModule(Vfs.lookup(component));
        }
    }

    private void addModules(EJBContainerImpl container, Object modulesValue) throws EJBException {
        if (modulesValue == null) {
            this.addModulesFromClasspath(container, null);
        } else if (modulesValue instanceof String) {
            HashSet<String> modules = new HashSet<String>();
            modules.add((String)modulesValue);
            this.addModulesFromClasspath(container, modules);
        } else if (modulesValue instanceof String[]) {
            HashSet<String> modules = new HashSet<String>();
            for (String module : (String[])modulesValue) {
                modules.add(module);
            }
            this.addModulesFromClasspath(container, modules);
        } else if (modulesValue instanceof File) {
            File file = (File)modulesValue;
            container.addModule(Vfs.lookup(file.getPath()));
        } else if (modulesValue instanceof File[]) {
            File[] files;
            for (File file : files = (File[])modulesValue) {
                container.addModule(Vfs.lookup(file.getPath()));
            }
        } else {
            throw new EJBException("Value of 'javax.ejb.embeddable.modules' (EJBContainer.MODULES) must be one of the types String, String[], java.io.File, or java.io.File[]");
        }
    }

    private void setWorkDir() {
        this.setWorkDir(null);
    }

    private void setWorkDir(Object workDirValue) throws EJBException {
        if (workDirValue != null) {
            Path workDir = null;
            if (workDirValue instanceof String) {
                workDir = Vfs.lookup((String)workDirValue);
            } else if (workDirValue instanceof File) {
                workDir = Vfs.lookup(((File)workDirValue).getPath());
            } else {
                throw new EJBException("Value of 'com.caucho.ejb.embeddable.workDir' must be either a String or java.io.File");
            }
            WorkDir.setLocalWorkDir(workDir);
        } else {
            Path tmpDir = Vfs.lookup(System.getProperty("java.io.tmpdir"));
            String userName = System.getProperty("user.name");
            Path workDir = tmpDir.lookup(userName).lookup("caucho-ejb");
            WorkDir.setLocalWorkDir(workDir);
        }
    }
}

