/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.AspectGeneratorUtil;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class NonBusinessMethodGenerator<X>
implements AspectGenerator<X> {
    private final AnnotatedMethod<? super X> _method;

    public NonBusinessMethodGenerator(AnnotatedMethod<? super X> method) {
        this._method = method;
    }

    protected boolean isOverride() {
        return true;
    }

    @Override
    public AnnotatedMethod<? super X> getMethod() {
        return this._method;
    }

    protected Method getJavaMethod() {
        return this._method.getJavaMember();
    }

    protected Class<?>[] getThrowsExceptions() {
        return this.getJavaMethod().getExceptionTypes();
    }

    @Override
    public void generate(JavaWriter out, HashMap<String, Object> prologueMap) throws IOException {
        int modifiers = this.getJavaMethod().getModifiers();
        String accessModifier = null;
        if (Modifier.isProtected(modifiers)) {
            accessModifier = "protected";
        } else if (Modifier.isPublic(modifiers) || Modifier.isPrivate(modifiers)) {
            throw new IllegalStateException(this.getJavaMethod().toString() + " must be protected or package protected");
        }
        String prefix = "";
        String suffix = "";
        AspectGeneratorUtil.generateHeader(out, this.isOverride(), accessModifier, prefix, this.getJavaMethod(), suffix, this.getThrowsExceptions());
        out.println("{");
        out.pushDepth();
        out.println("throw new EJBException(\"Illegal non-business method call\");");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateBeanPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    @Override
    public void generateBeanConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    @Override
    public void generateInject(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    @Override
    public void generateProxyConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    @Override
    public void generatePostConstruct(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    @Override
    public void generatePreDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    @Override
    public void generateEpilogue(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    @Override
    public void generateDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    @Override
    public void generateAsync(JavaWriter out) throws IOException {
    }

    @Override
    public void generatePreTry(JavaWriter out) throws IOException {
    }

    @Override
    public void generatePreCall(JavaWriter out) throws IOException {
    }

    @Override
    public void generateCall(JavaWriter out) throws IOException {
    }

    @Override
    public void generatePostCall(JavaWriter out) throws IOException {
    }

    @Override
    public boolean isApplicationExceptionThrown() {
        return true;
    }

    @Override
    public void generateApplicationException(JavaWriter out, Class<?> exn) throws IOException {
    }

    @Override
    public void generateSystemException(JavaWriter out, Class<?> exn) throws IOException {
    }

    @Override
    public void generateFinally(JavaWriter out) throws IOException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._method + "]";
    }
}

