/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.gen.SessionGenerator;
import com.caucho.ejb.gen.StatefulAspectBeanFactory;
import com.caucho.ejb.session.StatefulHandle;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.SessionBean;
import javax.ejb.Stateful;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class StatefulGenerator<X>
extends SessionGenerator<X> {
    private final AspectBeanFactory<X> _aspectBeanFactory;

    public StatefulGenerator(String ejbName, AnnotatedType<X> beanType, ArrayList<AnnotatedType<? super X>> localApi, AnnotatedType<X> localBean, ArrayList<AnnotatedType<? super X>> remoteApi) {
        super(ejbName, beanType, localApi, localBean, remoteApi, Stateful.class.getSimpleName());
        InjectManager manager = InjectManager.create();
        this._aspectBeanFactory = new StatefulAspectBeanFactory(manager, this.getBeanType());
    }

    @Override
    protected AspectBeanFactory<X> getAspectBeanFactory() {
        return this._aspectBeanFactory;
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    protected boolean isTimerSupported() {
        return false;
    }

    public String getContextClassName() {
        return this.getClassName();
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public String getViewClassName() {
        return "StatefulProxy";
    }

    @Override
    public String getBeanClassName() {
        return this.getBeanType().getJavaClass().getName();
    }

    @Override
    protected AnnotatedType<? super X> introspectLocalDefault() {
        return this.getBeanType();
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        this.generateTopComment(out);
        out.println();
        out.println("package " + this.getPackageName() + ";");
        out.println();
        out.println("import com.caucho.config.*;");
        out.println("import com.caucho.config.inject.CreationalContextImpl;");
        out.println("import com.caucho.ejb.*;");
        out.println("import com.caucho.ejb.session.*;");
        out.println();
        out.println("import javax.ejb.*;");
        out.println("import javax.transaction.*;");
        this.generateClassHeader(out);
        out.println("{");
        out.pushDepth();
        this.generateClassStaticFields(out);
        this.generateClassContent(out);
        this.generateDependency(out);
        out.popDepth();
        out.println("}");
    }

    private void generateClassHeader(JavaWriter out) throws IOException {
        out.println();
        out.println("public class " + this.getClassName() + "<T>");
        if (this.hasNoInterfaceView()) {
            out.println("  extends " + this.getBeanType().getJavaClass().getName());
        }
        out.print("  implements SessionProxyFactory<T>, com.caucho.config.gen.CandiEnhancedBean, java.io.Serializable");
        for (AnnotatedType api : this.getLocalApi()) {
            out.print(", " + api.getJavaClass().getName());
        }
        for (AnnotatedType apiType : this.getRemoteApi()) {
            out.print(", " + apiType.getJavaClass().getName());
        }
        out.println();
    }

    @Override
    protected void generateClassContent(JavaWriter out) throws IOException {
        out.println("private transient StatefulManager _manager;");
        out.println("private transient StatefulContext _context;");
        out.println("private " + this.getBeanClassName() + " _bean;");
        out.println("private transient boolean _isActive;");
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.generateContentImpl(out, map);
        this.generateSerialization(out);
    }

    @Override
    protected void generateContentImpl(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this.generateConstructor(out, map);
        this.generateProxyFactory(out);
        this.generateBeanPrologue(out, map);
        this.generateBusinessMethods(out, map);
        this.generateEpilogue(out, map);
        this.generateInject(out, map);
        this.generateDelegate(out, map);
        this.generatePostConstruct(out, map);
        this.generateDestroy(out, map);
    }

    private void generateConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
        out.println();
        out.print("public " + this.getClassName() + "(StatefulManager manager, ");
        out.println("StatefulContext context)");
        out.println("{");
        out.pushDepth();
        out.println("_manager = manager;");
        out.println("_context = context;");
        out.println("if (__caucho_exception != null)");
        out.println("  throw __caucho_exception;");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("private " + this.getClassName() + "(StatefulManager manager" + ", StatefulContext context" + ", CreationalContextImpl<T> env)");
        out.println("{");
        out.pushDepth();
        out.println("_manager = manager;");
        out.println("_context = context;");
        out.println("_bean = (" + this.getBeanClassName() + ") _manager.newInstance(env);");
        if (SessionBean.class.isAssignableFrom(this.getBeanType().getJavaClass())) {
            out.println("_bean.setSessionContext(context);");
        }
        this.generateContextObjectConstructor(out);
        out.popDepth();
        out.println("}");
    }

    private void generateProxyFactory(JavaWriter out) throws IOException {
        out.println();
        out.println("@Override");
        out.println("public T __caucho_createProxy(CreationalContextImpl<T> env)");
        out.println("{");
        out.println("  return (T) new " + this.getClassName() + "(_manager, _context, env);");
        out.println("}");
    }

    @Override
    public void generateDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateDestroy(out, map);
        out.println();
        out.println("@Override");
        out.println("public void __caucho_destroy() {}");
    }

    @Override
    protected void generateDestroyImpl(JavaWriter out) throws IOException {
        super.generateDestroyImpl(out);
        out.println("_manager.destroy(_bean, env);");
        out.println("_bean = null;");
    }

    private void generateSerialization(JavaWriter out) throws IOException {
        out.println("private Object writeReplace()");
        out.println("{");
        out.pushDepth();
        out.print("return new ");
        out.printClass(StatefulHandle.class);
        out.println("(_manager.getEJBName(), null);");
        out.popDepth();
        out.println("}");
    }
}

