/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.message;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.cfg.JmsActivationConfig;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Named;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsResourceAdapter
implements ResourceAdapter {
    private static final L10N L = new L10N(JmsResourceAdapter.class);
    private static final Logger log = Logger.getLogger(JmsResourceAdapter.class.getName());
    private static final Method _onMessage;
    private final JmsActivationConfig _config;
    private final String _ejbName;
    private ConnectionFactory _connectionFactory;
    private Destination _destination;
    private int _consumerMax = 5;
    private int _acknowledgeMode = 1;
    private String _subscriptionName;
    private String _selector;
    private Connection _connection;
    private MessageEndpointFactory _endpointFactory;
    private ArrayList<Consumer> _consumers;
    private Lifecycle _lifecycle = new Lifecycle();

    public JmsResourceAdapter(String ejbName, JmsActivationConfig config) {
        this._ejbName = ejbName;
        this._config = config;
        this._destination = config.getDestinationObject();
    }

    public void setMessageSelector(String selector) {
        this._selector = selector;
    }

    public void setSubscriptionName(String subscriptionName) {
        this._subscriptionName = subscriptionName;
    }

    public void setConsumerMax(int consumerMax) {
        this._consumerMax = consumerMax;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this._acknowledgeMode = acknowledgeMode;
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
    }

    private void init() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        this._connectionFactory = this.getResource(ConnectionFactory.class, this._config.getConnectionFactoryName());
        if (this._connectionFactory == null) {
            throw new ConfigException(L.l("connection-factory must be specified for @MessageDriven bean"));
        }
        if (this._config.getDestinationType() == null) {
            throw new ConfigException(L.l("destination-type must be specified for @MessageDriven bean"));
        }
        if (this._destination == null) {
            this._destination = this.getResource(this._config.getDestinationType(), this._config.getDestinationName());
        }
        if (this._destination == null) {
            throw new ConfigException(L.l("destination must be specified for @MessageDriven bean"));
        }
    }

    public void stop() {
    }

    private <T> T getResource(Class<T> type, String name) {
        Set<Object> beans;
        if (name != null) {
            if (name.startsWith("java:comp")) {
                try {
                    InitialContext ic = new InitialContext();
                    return (T)ic.lookup(name);
                }
                catch (NamingException e) {
                    throw ConfigException.create(L.l("{0} is an unknown JNDI name for {1}\n  {2}", name, type.getName(), e.toString()), (Throwable)e);
                }
            }
            String jndiName = "java:comp/env/" + name;
            try {
                InitialContext ic = new InitialContext();
                Object value = ic.lookup(jndiName);
                if (value != null) {
                    return (T)value;
                }
            }
            catch (NamingException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        InjectManager beanManager = InjectManager.create();
        if (name != null) {
            Named named = Names.create(name);
            beans = beanManager.getBeans(type, new Annotation[]{named});
        } else {
            beans = beanManager.getBeans(type, new Annotation[0]);
        }
        Bean bean = beanManager.resolve(beans);
        if (bean == null) {
            throw new ConfigException(L.l("'{0}' with name='{1}' is an unknown JMS resource", (Object)type.getName(), name));
        }
        return (T)beanManager.getReference(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws NotSupportedException, ResourceException {
        this.init();
        JmsResourceAdapter jmsResourceAdapter = this;
        synchronized (jmsResourceAdapter) {
            if (this._consumers != null) {
                throw new IllegalStateException();
            }
            this._consumers = new ArrayList();
        }
        try {
            Connection connection;
            assert (this._connectionFactory != null);
            assert (this._destination != null);
            assert (this._consumerMax > 0);
            this._endpointFactory = endpointFactory;
            this._connection = connection = this._connectionFactory.createConnection();
            if (this._destination instanceof Topic) {
                this._consumerMax = 1;
            }
            for (int i = 0; i < this._consumerMax; ++i) {
                Consumer consumer = new Consumer(this._connection, this._destination);
                this._consumers.add(consumer);
                consumer.start();
            }
            this._connection.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        try {
            ArrayList<Consumer> consumers = this._consumers;
            this._consumers = null;
            if (consumers != null) {
                consumers = new ArrayList<Consumer>(consumers);
                for (Consumer consumer : consumers) {
                    consumer.destroy();
                }
            }
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return new XAResource[0];
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._ejbName + "," + this._destination + "]";
    }

    static {
        try {
            _onMessage = MessageListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    class Consumer {
        private Session _session;
        private XAResource _xaResource;
        private MessageConsumer _consumer;
        private MessageEndpoint _endpoint;
        private MessageListener _listener;

        Consumer(Connection conn, Destination destination) throws Exception {
            if (conn instanceof XAConnection) {
                boolean transacted = false;
                this._session = conn.createSession(transacted, 1);
            } else {
                boolean transacted = false;
                this._session = conn.createSession(transacted, JmsResourceAdapter.this._acknowledgeMode);
            }
            this._endpoint = JmsResourceAdapter.this._endpointFactory.createEndpoint(this._xaResource);
            this._listener = (MessageListener)this._endpoint;
        }

        void start() throws Exception {
            if (JmsResourceAdapter.this._subscriptionName != null) {
                Topic topic = (Topic)JmsResourceAdapter.this._destination;
                this._consumer = this._session.createDurableSubscriber(topic, JmsResourceAdapter.this._subscriptionName, JmsResourceAdapter.this._selector, true);
            } else {
                this._consumer = this._session.createConsumer(JmsResourceAdapter.this._destination, JmsResourceAdapter.this._selector);
            }
            this._consumer.setMessageListener(this._listener);
        }

        public Session getSession() throws JMSException {
            return this._session;
        }

        private void destroy() throws JMSException {
            this._endpoint.release();
        }
    }
}

