/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.ejb.SessionPool;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.gen.StatelessGenerator;
import com.caucho.ejb.inject.StatelessBeanImpl;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.server.AbstractContext;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.AbstractSessionManager;
import com.caucho.ejb.session.StatelessContext;
import com.caucho.ejb.session.StatelessPool;
import com.caucho.ejb.session.StatelessProviderProxy;
import com.caucho.util.L10N;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.SessionBeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessManager<X>
extends AbstractSessionManager<X> {
    private static final L10N L = new L10N(StatelessManager.class);
    private static Logger log = Logger.getLogger(StatelessManager.class.getName());
    private int _sessionIdleMax = 16;
    private int _sessionConcurrentMax = -1;
    private long _sessionConcurrentTimeout = -1L;

    public StatelessManager(EjbManager ejbContainer, String moduleName, AnnotatedType<X> rawAnnType, AnnotatedType<X> annotatedType, EjbLazyGenerator<X> ejbGenerator) {
        super(ejbContainer, moduleName, rawAnnType, annotatedType, ejbGenerator);
        this.introspect();
    }

    @Override
    protected String getType() {
        return "stateless:";
    }

    @Override
    protected SessionBeanType getSessionBeanType() {
        return SessionBeanType.STATELESS;
    }

    public int getSessionIdleMax() {
        return this._sessionIdleMax;
    }

    public int getSessionConcurrentMax() {
        return this._sessionConcurrentMax;
    }

    public long getSessionConcurrentTimeout() {
        return this._sessionConcurrentTimeout;
    }

    @Override
    protected <T> StatelessContext<X, T> getSessionContext(Class<T> api) {
        return (StatelessContext)super.getSessionContext(api);
    }

    @Override
    public <T> Object getLocalJndiProxy(Class<T> api) {
        AbstractSessionContext context = this.getSessionContext((Class)api);
        return new StatelessProviderProxy(context.createProxy(null));
    }

    @Override
    public <T> T getLocalProxy(Class<T> api) {
        return this.getSessionContext((Class)api).createProxy(null);
    }

    @Override
    protected <T> Bean<T> createBean(ManagedBeanImpl<X> mBean, Class<T> api, Set<Type> apiList, AnnotatedType<X> extAnnType) {
        AbstractSessionContext context = this.getSessionContext((Class)api);
        if (context == null) {
            throw new NullPointerException(L.l("'{0}' is an unknown api for {1}", api, this));
        }
        StatelessBeanImpl<X, T> statelessBean = new StatelessBeanImpl<X, T>(this, mBean, api, apiList, context, extAnnType);
        return statelessBean;
    }

    @Override
    protected Class<?> getContextClass() {
        return StatelessContext.class;
    }

    @Override
    protected BeanGenerator<X> createBeanGenerator() {
        EjbLazyGenerator lazyGen = this.getLazyGenerator();
        return new StatelessGenerator(this.getEJBName(), this.getAnnotatedType(), lazyGen.getLocalApi(), lazyGen.getLocalBean(), lazyGen.getRemoteApi());
    }

    public <T> StatelessPool<X, T> createStatelessPool(StatelessContext<X, T> context, List<Interceptor<?>> interceptorBeans) {
        return new StatelessPool<X, T>(this, context, interceptorBeans);
    }

    @Override
    public <T> T getRemoteObject(Class<T> api, String protocol) {
        if (api == null) {
            return null;
        }
        AbstractSessionContext context = this.getSessionContext((Class)api);
        if (context != null) {
            Object result = context.createProxy(null);
            return result;
        }
        log.fine(this + " unknown api " + api.getName());
        return null;
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    private void introspect() {
        AnnotatedType annType = this.getAnnotatedType();
        SessionPool sessionPool = (SessionPool)annType.getAnnotation(SessionPool.class);
        if (sessionPool != null) {
            if (sessionPool.maxIdle() >= 0) {
                this._sessionIdleMax = sessionPool.maxIdle();
            }
            if (sessionPool.maxConcurrent() >= 0) {
                this._sessionConcurrentMax = sessionPool.maxConcurrent();
            }
            if (sessionPool.maxConcurrentTimeout() >= 0L) {
                this._sessionConcurrentTimeout = sessionPool.maxConcurrentTimeout();
            }
        }
    }

    @Override
    protected <T> StatelessContext<X, T> createSessionContext(Class<T> api) {
        return new StatelessContext(this, api);
    }

    @Override
    protected void postStart() {
    }

    @Override
    public AbstractContext getContext(Object key, boolean forceLoad) {
        return this.getContext();
    }

    public Object[] getInterceptorBindings(List<Interceptor<?>> interceptorBeans, CreationalContextImpl<?> parentEnv) {
        int size = interceptorBeans.size();
        if (size == 0) {
            return null;
        }
        Object[] interceptors = new Object[size];
        for (int i = 0; i < size; ++i) {
            Interceptor<?> bean = interceptorBeans.get(i);
            interceptors[i] = this.getInjectManager().getReference(bean, parentEnv);
        }
        return interceptors;
    }
}

