/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.util;

import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.util.AppExceptionItem;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.UserTransactionProxy;
import com.caucho.util.L10N;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.SessionSynchronization;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class XAManager {
    private static L10N L = new L10N(XAManager.class);
    private UserTransactionProxy _ut = UserTransactionProxy.getInstance();
    private EjbManager _ejbManager = EjbManager.getCurrent();

    public void enlist(XAResource xaResource) {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            TransactionImpl xa = tm.getTransaction();
            if (xa != null && xaResource != null) {
                xa.enlistResource(xaResource);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void registerSynchronization(SessionSynchronization sync) {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            TransactionImpl xa = tm.getTransaction();
            if (xa != null && sync != null) {
                sync.afterBegin();
                xa.registerSynchronization(new SynchronizationAdapter(sync));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void beginMandatory() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            TransactionImpl xa = tm.getTransaction();
            if (xa == null) {
                throw new EJBTransactionRequiredException(L.l("Transaction required for 'Mandatory' transaction attribute"));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void beginNever() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            TransactionImpl xa = tm.getTransaction();
            if (xa != null) {
                throw new EJBException(L.l("Transaction forbidden for 'Never' transaction attribute"));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public Transaction beginRequired() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            TransactionImpl xa = tm.getTransaction();
            if (xa != null) {
                return xa;
            }
            this._ut.begin();
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public Transaction beginRequiresNew() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            Transaction xa = tm.suspend();
            this._ut.begin();
            return xa;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endRequiresNew(Transaction parent) {
        block11: {
            TransactionImpl xa = this.getTransaction();
            if (xa != null && xa.isRollbackOnly()) {
                this._ut.rollback();
                break block11;
            }
            this._ut.commit();
        }
        Object var4_5 = null;
        try {
            if (parent == null) return;
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            tm.resume(parent);
            return;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        {
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (parent == null) throw throwable;
                TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
                tm.resume(parent);
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
    }

    public Transaction beginNotSupported() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            return tm.suspend();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public TransactionImpl getTransaction() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            return tm.getTransaction();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public boolean systemException(RuntimeException e) {
        TransactionImpl xa = this.getTransaction();
        AppExceptionItem appExn = null;
        if (this._ejbManager != null) {
            appExn = this._ejbManager.getSystemException(e.getClass());
        }
        if (appExn == null || appExn.isRollback()) {
            if (xa != null) {
                xa.setRollbackOnly(e);
            }
            return appExn == null;
        }
        return false;
    }

    public void applicationException(Throwable e) {
        TransactionImpl xa = this.getTransaction();
        if (xa == null) {
            return;
        }
        AppExceptionItem appExn = null;
        if (this._ejbManager != null) {
            appExn = this._ejbManager.getApplicationException(e.getClass());
        }
        if (appExn != null && appExn.isRollback()) {
            xa.setRollbackOnly(e);
        }
    }

    public void markRollback(Exception e) {
        this._ut.setRollbackOnly(e);
    }

    public void markRollback() {
        try {
            if (this._ut.getStatus() == 0) {
                this._ut.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public void rethrowEjbException(Exception e, boolean isClientXa) {
        if (isClientXa) {
            throw new EJBTransactionRolledbackException(e.getMessage(), e);
        }
        throw new EJBException(e);
    }

    public void commit() {
        try {
            TransactionImpl xa = this.getTransaction();
            if (xa != null && xa.isRollbackOnly()) {
                this._ut.rollback();
            } else {
                this._ut.commit();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (RollbackException e) {
            throw new TransactionRolledbackLocalException(e.getMessage(), (Exception)((Object)e));
        }
        catch (HeuristicMixedException e) {
            throw new TransactionRolledbackLocalException(e.getMessage(), (Exception)((Object)e));
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionRolledbackLocalException(e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void rollback() {
        try {
            TransactionImpl xa = this.getTransaction();
            if (xa != null) {
                this._ut.rollback();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void resume(Transaction xa) {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            tm.resume(xa);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public String toString() {
        return "XAManager[]";
    }

    public static class SynchronizationAdapter
    implements Synchronization {
        private final SessionSynchronization _sync;

        SynchronizationAdapter(SessionSynchronization sync) {
            this._sync = sync;
        }

        public void beforeCompletion() {
            try {
                this._sync.beforeCompletion();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }

        public void afterCompletion(int status) {
            try {
                this._sync.afterCompletion(status == 3);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._sync + "]";
        }
    }
}

