/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;

public class AddExpr
extends Expr {
    private final Expr _left;
    private final Expr _right;

    public AddExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public Object getValue(ELContext env) throws ELException {
        Object aObj = this._left.getValue(env);
        Object bObj = this._right.getValue(env);
        if (aObj instanceof BigDecimal || bObj instanceof BigDecimal) {
            BigDecimal a = AddExpr.toBigDecimal(aObj, env);
            BigDecimal b = AddExpr.toBigDecimal(bObj, env);
            return a.add(b);
        }
        if (AddExpr.isDouble(aObj)) {
            double b;
            if (bObj instanceof BigInteger) {
                BigDecimal a = AddExpr.toBigDecimal(aObj, env);
                BigDecimal b2 = AddExpr.toBigDecimal(bObj, env);
                return a.add(b2);
            }
            double a = AddExpr.toDouble(aObj, env);
            double dValue = a + (b = AddExpr.toDouble(bObj, env));
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        if (AddExpr.isDouble(bObj)) {
            double b;
            if (aObj instanceof BigInteger) {
                BigDecimal a = AddExpr.toBigDecimal(aObj, env);
                BigDecimal b3 = AddExpr.toBigDecimal(bObj, env);
                return a.add(b3);
            }
            double a = AddExpr.toDouble(aObj, env);
            double dValue = a + (b = AddExpr.toDouble(bObj, env));
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        if (aObj instanceof BigInteger || bObj instanceof BigInteger) {
            BigInteger a = AddExpr.toBigInteger(aObj, env);
            BigInteger b = AddExpr.toBigInteger(bObj, env);
            return a.add(b);
        }
        if (bObj instanceof Double || bObj instanceof Float) {
            double b;
            double a = AddExpr.toDouble(aObj, env);
            double dValue = a + (b = ((Number)bObj).doubleValue());
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        if (aObj instanceof Number) {
            long a = ((Number)aObj).longValue();
            long b = AddExpr.toLong(bObj, env);
            return new Long(a + b);
        }
        if (bObj instanceof Number) {
            long a = AddExpr.toLong(aObj, env);
            long b = ((Number)bObj).longValue();
            return new Long(a + b);
        }
        if (AddExpr.isDoubleString(aObj) || AddExpr.isDoubleString(bObj)) {
            double a = AddExpr.toDouble(aObj, env);
            double b = AddExpr.toDouble(bObj, env);
            return new Double(a + b);
        }
        long a = AddExpr.toLong(aObj, env);
        long b = AddExpr.toLong(bObj, env);
        return new Long(a + b);
    }

    public long evalLong(ELContext env) throws ELException {
        long a = this._left.evalLong(env);
        long b = this._right.evalLong(env);
        return a + b;
    }

    public double evalDouble(ELContext env) throws ELException {
        double a = this._left.evalDouble(env);
        double b = this._right.evalDouble(env);
        return a + b;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.AddExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof AddExpr)) {
            return false;
        }
        AddExpr expr = (AddExpr)((Object)o);
        return this._left.equals((Object)expr._left) && this._right.equals((Object)expr._right);
    }

    public String toString() {
        return "(" + (Object)((Object)this._left) + " + " + (Object)((Object)this._right) + ")";
    }
}

