/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ELException;

public abstract class Marshall {
    private static final HashMap<Class, Marshall> ARG_MAP = new HashMap();
    public static final Marshall BOOLEAN = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            return new Boolean(expr.evalBoolean(env));
        }
    };
    public static final Marshall BYTE = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            return new Byte((byte)expr.evalLong(env));
        }
    };
    public static final Marshall SHORT = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            return new Short((short)expr.evalLong(env));
        }
    };
    public static final Marshall INTEGER = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            return new Integer((int)expr.evalLong(env));
        }
    };
    public static final Marshall LONG = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            return new Long(expr.evalLong(env));
        }
    };
    public static final Marshall FLOAT = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            return new Float((float)expr.evalDouble(env));
        }
    };
    public static final Marshall DOUBLE = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            return new Double(expr.evalDouble(env));
        }
    };
    public static final Marshall STRING = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            return expr.evalString(env);
        }
    };
    public static final Marshall CHARACTER = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            String s = expr.evalString(env);
            if (s == null || s.length() == 0) {
                return null;
            }
            return new Character(s.charAt(0));
        }
    };
    public static final Marshall OBJECT = new Marshall(){

        public Object marshall(Expr expr, ELContext env) throws ELException {
            return expr.getValue(env);
        }
    };

    public static Marshall create(Class arg) {
        Marshall marshall = ARG_MAP.get(arg);
        if (marshall != null) {
            return marshall;
        }
        return OBJECT;
    }

    public abstract Object marshall(Expr var1, ELContext var2) throws ELException;

    static {
        ARG_MAP.put(Boolean.TYPE, BOOLEAN);
        ARG_MAP.put(Boolean.class, BOOLEAN);
        ARG_MAP.put(Byte.TYPE, BYTE);
        ARG_MAP.put(Byte.class, BYTE);
        ARG_MAP.put(Short.TYPE, SHORT);
        ARG_MAP.put(Short.class, SHORT);
        ARG_MAP.put(Integer.TYPE, INTEGER);
        ARG_MAP.put(Integer.class, INTEGER);
        ARG_MAP.put(Long.TYPE, LONG);
        ARG_MAP.put(Long.class, LONG);
        ARG_MAP.put(Float.TYPE, FLOAT);
        ARG_MAP.put(Float.class, FLOAT);
        ARG_MAP.put(Double.TYPE, DOUBLE);
        ARG_MAP.put(Double.class, DOUBLE);
        ARG_MAP.put(Character.TYPE, CHARACTER);
        ARG_MAP.put(Character.class, CHARACTER);
        ARG_MAP.put(String.class, STRING);
    }
}

