/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;

public class MinusExpr
extends Expr {
    private final Expr _expr;

    public MinusExpr(Expr expr) {
        this._expr = expr;
    }

    public boolean isConstant() {
        return this._expr.isConstant();
    }

    public Object getValue(ELContext env) throws ELException {
        Object obj = this._expr.getValue(env);
        if (obj == null) {
            return new Long(0L);
        }
        Class<?> type = obj.getClass();
        if (Long.class == type) {
            return new Long(-((Number)obj).longValue());
        }
        if (Double.class == type) {
            return new Double(-((Number)obj).doubleValue());
        }
        if (Integer.class == type) {
            return new Integer(-((Number)obj).intValue());
        }
        if (Short.class == type) {
            return new Short(-((Number)obj).shortValue());
        }
        if (Byte.class == type) {
            return new Byte(-((Number)obj).byteValue());
        }
        if (Float.class == type) {
            return new Float(-((Number)obj).floatValue());
        }
        if (BigDecimal.class == type) {
            return ((BigDecimal)obj).negate();
        }
        if (BigInteger.class == type) {
            return ((BigInteger)obj).negate();
        }
        if (String.class == type && MinusExpr.isDouble(obj)) {
            return new Double(-MinusExpr.toDouble(obj, env));
        }
        if (String.class == type) {
            return new Long(-MinusExpr.toLong(obj, env));
        }
        throw new ELException(L.l("Can't convert {0} to number", obj));
    }

    public long evalLong(ELContext env) throws ELException {
        return -this._expr.evalLong(env);
    }

    public double evalDouble(ELContext env) throws ELException {
        return -this._expr.evalDouble(env);
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.MinusExpr(");
        this._expr.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof MinusExpr)) {
            return false;
        }
        MinusExpr uexpr = (MinusExpr)((Object)o);
        return this._expr.equals((Object)uexpr._expr);
    }

    public String toString() {
        return "-" + (Object)((Object)this._expr);
    }
}

