/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.env.deploy.DeployControllerAlarm;
import com.caucho.env.deploy.DeployControllerApi;
import com.caucho.env.deploy.DeployControllerStrategy;
import com.caucho.env.deploy.DeployControllerType;
import com.caucho.env.deploy.DeployInstance;
import com.caucho.env.deploy.DeployMode;
import com.caucho.env.deploy.StartAutoRedeployAutoStrategy;
import com.caucho.env.deploy.StartAutoRedeployManualStrategy;
import com.caucho.env.deploy.StartLazyRedeployAutomaticStrategy;
import com.caucho.env.deploy.StartLazyRedeployManualStrategy;
import com.caucho.env.deploy.StartManualRedeployManualStrategy;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleListener;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployController<I extends DeployInstance>
implements DeployControllerApi<I>,
Dependency {
    private static final Logger log = Logger.getLogger(DeployController.class.getName());
    private static final L10N L = new L10N(DeployController.class);
    public static final long REDEPLOY_CHECK_INTERVAL = 60000L;
    private ClassLoader _parentLoader;
    private final String _id;
    private final String _idStage;
    private final String _idType;
    private final String _idKey;
    private DeployMode _startupMode = DeployMode.DEFAULT;
    private DeployMode _redeployMode = DeployMode.DEFAULT;
    private int _startupPriority = Integer.MAX_VALUE;
    private DeployControllerStrategy _strategy = StartManualRedeployManualStrategy.STRATEGY;
    protected final Lifecycle _lifecycle;
    private DeployControllerAlarm<DeployController<I>> _alarm;
    private long _waitForActiveTimeout = 10000L;
    private long _redeployCheckInterval = 60000L;
    private long _startTime;
    private I _deployInstance;

    protected DeployController(String id) {
        this(id, null);
    }

    protected DeployController(String id, ClassLoader parentLoader) {
        this._id = id;
        if (parentLoader == null) {
            parentLoader = Thread.currentThread().getContextClassLoader();
        }
        this._parentLoader = parentLoader;
        this._lifecycle = new Lifecycle(this.getLog(), this.toString(), Level.FINEST);
        int p1 = id.indexOf(47);
        this._idStage = id.substring(0, p1);
        int p2 = id.indexOf(47, p1 + 1);
        this._idType = id.substring(p1 + 1, p2);
        this._idKey = id.substring(p2 + 1);
    }

    protected abstract I instantiateDeployInstance();

    @Override
    public final String getId() {
        return this._id;
    }

    public final String getIdStage() {
        return this._idStage;
    }

    public final String getIdType() {
        return this._idType;
    }

    public final String getIdKey() {
        return this._idKey;
    }

    public ClassLoader getParentClassLoader() {
        return this._parentLoader;
    }

    @Override
    public DeployControllerType getControllerType() {
        return DeployControllerType.STATIC;
    }

    public void setStartupMode(DeployMode mode) {
        this._startupMode = mode;
    }

    public void setStartupPriority(int priority) {
        this._startupPriority = priority;
    }

    @Override
    public int getStartupPriority() {
        return this._startupPriority;
    }

    @Override
    public void merge(DeployControllerApi<I> newController) {
    }

    public DeployMode getStartupMode() {
        return this._startupMode;
    }

    public void setRedeployMode(DeployMode mode) {
        this._redeployMode = mode;
    }

    public void mergeRedeployMode(DeployMode mode) {
        if (mode == null || DeployMode.DEFAULT.equals((Object)mode)) {
            return;
        }
        this._redeployMode = mode;
    }

    public DeployMode getRedeployMode() {
        return this._redeployMode;
    }

    public void mergeRedeployCheckInterval(long interval) {
        if (interval != 60000L) {
            this._redeployCheckInterval = interval;
        }
    }

    public void setRedeployCheckInterval(Period period) {
        this._redeployCheckInterval = period.getPeriod();
        if (this._redeployCheckInterval < 0L) {
            this._redeployCheckInterval = 4611686018427387000L;
        }
        if (this._redeployCheckInterval < 5000L) {
            this._redeployCheckInterval = 5000L;
        }
    }

    public long getRedeployCheckInterval() {
        return this._redeployCheckInterval;
    }

    @Override
    public boolean isNameMatch(String name) {
        return this.getId().equals(name);
    }

    public final long getStartTime() {
        return this._startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean init() {
        if (!this._lifecycle.toInitializing()) {
            return false;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            this.initBegin();
            switch (this._startupMode) {
                case MANUAL: {
                    if (this._redeployMode == DeployMode.AUTOMATIC) {
                        throw new IllegalStateException(L.l("startup='manual' and redeploy='automatic' is an unsupported combination."));
                    }
                    this._strategy = StartManualRedeployManualStrategy.create();
                    break;
                }
                case LAZY: {
                    if (this._redeployMode == DeployMode.MANUAL) {
                        this._strategy = StartLazyRedeployManualStrategy.create();
                        break;
                    }
                    this._strategy = StartLazyRedeployAutomaticStrategy.create();
                    break;
                }
                default: {
                    this._strategy = this._redeployMode == DeployMode.MANUAL ? StartAutoRedeployManualStrategy.create() : StartAutoRedeployAutoStrategy.create();
                }
            }
            this.initEnd();
            boolean bl = this._lifecycle.toInit();
            return bl;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void initBegin() {
    }

    protected void initEnd() {
    }

    @Override
    public final LifecycleState getState() {
        return this._lifecycle.getState();
    }

    public final boolean isIdleTimeout() {
        I instance = this.getDeployInstance();
        if (instance != null) {
            return instance.isDeployIdle();
        }
        return false;
    }

    @Override
    public boolean isModified() {
        if (this.isControllerModified()) {
            return true;
        }
        I instance = this.getDeployInstance();
        return instance == null || instance.isModified();
    }

    public boolean isModifiedNow() {
        if (this.isControllerModifiedNow()) {
            return true;
        }
        I instance = this.getDeployInstance();
        return instance == null || instance.isModifiedNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean logModified(Logger log) {
        if (this.controllerLogModified(log)) {
            return true;
        }
        I instance = this.getDeployInstance();
        if (instance != null) {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(instance.getClassLoader());
                boolean bl = instance.logModified(log);
                return bl;
            }
            finally {
                thread.setContextClassLoader(loader);
            }
        }
        return false;
    }

    protected boolean isControllerModified() {
        return false;
    }

    protected boolean isControllerModifiedNow() {
        return false;
    }

    protected boolean controllerLogModified(Logger log) {
        return false;
    }

    @Override
    public final I getDeployInstance() {
        return this._deployInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final I createDeployInstance() {
        DeployController deployController = this;
        synchronized (deployController) {
            if (this._deployInstance == null) {
                Thread thread = Thread.currentThread();
                ClassLoader oldLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(this._parentLoader);
                    this._deployInstance = this.instantiateDeployInstance();
                }
                finally {
                    thread.setContextClassLoader(oldLoader);
                }
            }
            return this._deployInstance;
        }
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this._lifecycle.addListener(listener);
    }

    @Override
    public void startOnInit() {
        if (!this._lifecycle.isAfterInit()) {
            throw new IllegalStateException(L.l("startOnInit must be called after init (in '{0}')", this._lifecycle.getStateName()));
        }
        this._strategy.startOnInit(this);
        this._alarm = new DeployControllerAlarm<DeployController>(this, this._redeployCheckInterval);
    }

    @Override
    public final void start() {
        this._strategy.start(this);
    }

    @Override
    public final void stop() {
        this._strategy.stop(this);
    }

    @Override
    public final void restart() {
        this._strategy.stop(this);
        this._strategy.start(this);
    }

    @Override
    public final void update() {
        this._strategy.update(this);
    }

    @Override
    public final I request() {
        if (this._lifecycle.isDestroyed()) {
            return null;
        }
        if (this._strategy != null) {
            Object instance = this._strategy.request(this);
            return instance;
        }
        return null;
    }

    @Override
    public final I subrequest() {
        if (this._lifecycle.isDestroyed()) {
            return null;
        }
        if (this._strategy != null) {
            Object instance = this._strategy.subrequest(this);
            return instance;
        }
        return null;
    }

    final I restartImpl() {
        if (!this._lifecycle.isStopped() && !this._lifecycle.isInit()) {
            this.stopImpl();
        }
        return this.startImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected I startImpl() {
        assert (this._lifecycle.isAfterInit());
        if (DynamicClassLoader.isModified(this._parentLoader)) {
            this._deployInstance = null;
            return null;
        }
        DeployInstance deployInstance = null;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        ClassLoader loader = null;
        boolean isStarting = false;
        boolean isActive = false;
        try {
            thread.setContextClassLoader(this._parentLoader);
            deployInstance = (DeployInstance)this.createDeployInstance();
            if (deployInstance == null) {
                throw new NullPointerException(this.getClass().getName());
            }
            loader = deployInstance.getClassLoader();
            thread.setContextClassLoader(loader);
            isStarting = this._lifecycle.toStarting();
            if (!isStarting) {
                this._lifecycle.waitForActive(this._waitForActiveTimeout);
                DeployInstance deployInstance2 = deployInstance;
                return (I)deployInstance2;
            }
            this.preConfigureInstance(deployInstance);
            this.configureInstance(deployInstance);
            this.postConfigureInstance(deployInstance);
            deployInstance.start();
            isActive = true;
            this._startTime = Alarm.getCurrentTime();
        }
        catch (ConfigException e) {
            log.log(Level.FINEST, e.toString(), e);
            this._lifecycle.toError();
            this.onError(e);
            if (deployInstance != null) {
                log.finer(e.toString());
                deployInstance.setConfigException(e);
            } else {
                log.severe(e.toString());
            }
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
            this._lifecycle.toError();
            this.onError(e);
            if (deployInstance != null) {
                log.finer(e.toString());
                deployInstance.setConfigException(e);
            } else {
                log.log(Level.SEVERE, e.toString(), e);
            }
        }
        finally {
            if (isActive) {
                this._lifecycle.toActive();
                this.onActive();
            } else {
                this._lifecycle.toError();
            }
            if (loader instanceof DynamicClassLoader) {
                ((DynamicClassLoader)loader).clearModified();
            }
            thread.setContextClassLoader(oldLoader);
        }
        return (I)deployInstance;
    }

    final void stopLazyImpl() {
        if (!this._lifecycle.isIdle()) {
            this.stopImpl();
        }
        this._lifecycle.toIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stopImpl() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        I oldInstance = this._deployInstance;
        boolean isStopping = false;
        try {
            if (oldInstance != null) {
                thread.setContextClassLoader(oldInstance.getClassLoader());
            }
            if (!(isStopping = this._lifecycle.toStopping())) {
                return;
            }
            DeployController deployController = this;
            synchronized (deployController) {
                oldInstance = this._deployInstance;
                this._deployInstance = null;
            }
            if (oldInstance != null) {
                this.destroyInstance(oldInstance);
            }
        }
        finally {
            if (isStopping) {
                this._lifecycle.toStop();
                this.onStop();
            }
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void destroyInstance(I instance) {
        instance.destroy();
    }

    protected void onActive() {
    }

    protected void onError(Throwable e) {
    }

    protected void onStop() {
    }

    protected void preConfigureInstance(I deployInstance) throws Exception {
    }

    protected void configureInstance(I deployInstance) throws Exception {
    }

    protected void postConfigureInstance(I deployInstance) throws Exception {
    }

    @Override
    public final void alarm() {
        this._strategy.alarm(this);
    }

    @Override
    public final void close() {
        this.destroy();
    }

    protected boolean destroy() {
        if (this._lifecycle.isAfterInit()) {
            this.stop();
        }
        if (!this._lifecycle.toDestroy()) {
            return false;
        }
        DeployControllerAlarm<DeployController<I>> alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.close();
        }
        return true;
    }

    protected Logger getLog() {
        return log;
    }

    public String toString() {
        String className = this.getClass().getName();
        int p = className.lastIndexOf(46);
        return className.substring(p + 1) + "[" + this.getId() + "]";
    }
}

