/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.env.deploy.DeployTagItem;
import com.caucho.env.deploy.DeployTagListener;
import com.caucho.env.deploy.DeployUpdateListener;
import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class DeployControllerService
extends AbstractResinService {
    private static final L10N L = new L10N(DeployControllerService.class);
    public static final int START_PRIORITY = 50;
    private final ConcurrentHashMap<String, DeployTagItem> _deployMap = new ConcurrentHashMap();
    private final List<DeployTagListener> _tagListeners = new CopyOnWriteArrayList<DeployTagListener>();
    private final List<DeployUpdateListener> _updateListeners = new CopyOnWriteArrayList<DeployUpdateListener>();

    public static DeployControllerService getCurrent() {
        ResinSystem server = ResinSystem.getCurrent();
        if (server != null) {
            return server.getService(DeployControllerService.class);
        }
        return null;
    }

    public static DeployControllerService create() {
        ResinSystem system = ResinSystem.getCurrent();
        if (system == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1}", (Object)DeployControllerService.class.getSimpleName(), ResinSystem.class.getSimpleName()));
        }
        DeployControllerService service = system.getService(DeployControllerService.class);
        if (service == null) {
            service = new DeployControllerService();
            system.addServiceIfAbsent(service);
            service = system.getService(DeployControllerService.class);
        }
        return service;
    }

    public DeployTagItem addTag(String tagName) {
        DeployTagItem item = new DeployTagItem(tagName);
        DeployTagItem oldItem = this._deployMap.putIfAbsent(tagName, item);
        if (oldItem != null) {
            return oldItem;
        }
        for (DeployTagListener listener : this._tagListeners) {
            listener.onTagAdd(tagName);
        }
        return item;
    }

    public void removeTag(String tagName) {
        DeployTagItem oldItem = this._deployMap.remove(tagName);
        if (oldItem != null) {
            for (DeployTagListener listener : this._tagListeners) {
                listener.onTagRemove(tagName);
            }
        }
    }

    public Set<String> getTagNames() {
        return this._deployMap.keySet();
    }

    public DeployTagItem getTagItem(String tag) {
        return this._deployMap.get(tag);
    }

    public void addTagListener(DeployTagListener listener) {
        this._tagListeners.add(listener);
        for (String tag : this._deployMap.keySet()) {
            listener.onTagAdd(tag);
        }
    }

    public void removeTagListener(DeployTagListener listener) {
        this._tagListeners.remove(listener);
    }

    public void update(String tag) {
        for (DeployUpdateListener listener : this._updateListeners) {
            listener.onUpdate(tag);
        }
    }

    public void addUpdateListener(DeployUpdateListener listener) {
        this._updateListeners.add(listener);
    }

    public void removeUpdateListener(DeployUpdateListener listener) {
        this._updateListeners.remove(listener);
    }

    @Override
    public int getStartPriority() {
        return 50;
    }
}

