/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.env.deploy.ExpandArchiveManager;
import com.caucho.env.deploy.ExpandDirectoryManager;
import com.caucho.env.deploy.ExpandRepositoryManager;
import com.caucho.env.deploy.ExpandVersion;
import com.caucho.env.deploy.ExpandVersionGroup;
import com.caucho.env.deploy.ExpandVersionManager;
import com.caucho.util.Crc64;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpandManager {
    private final String _id;
    private final ExpandDirectoryManager _directoryManager;
    private final ExpandArchiveManager _archiveManager;
    private final ExpandRepositoryManager _repositoryManager;
    private final ExpandVersionManager _versionManager;

    public ExpandManager(String id, ExpandDirectoryManager directoryManager, ExpandArchiveManager archiveManager, ExpandRepositoryManager repositoryManager, boolean isVersioning) {
        this._id = id;
        this._directoryManager = directoryManager;
        this._archiveManager = archiveManager;
        this._repositoryManager = repositoryManager;
        TreeSet<String> keySet = new TreeSet<String>();
        keySet.addAll(this._directoryManager.getDeployedKeys());
        keySet.addAll(this._archiveManager.getDeployedKeys());
        keySet.addAll(this._repositoryManager.getDeployedKeys());
        this._versionManager = new ExpandVersionManager(id, keySet, isVersioning);
    }

    boolean isModified() {
        return this._directoryManager.isModified() || this._archiveManager.isModified() || this._repositoryManager.isModified();
    }

    long getDigest() {
        long digest = 0L;
        digest = Crc64.generate(digest, this._directoryManager.getDigest());
        digest = Crc64.generate(digest, this._repositoryManager.calculateDigest());
        return digest;
    }

    boolean logModified(Logger log) {
        if (this._directoryManager.logModified(log)) {
            return true;
        }
        if (this._archiveManager.logModified(log)) {
            return true;
        }
        return this._repositoryManager.logModified(log);
    }

    Set<String> getBaseKeySet() {
        return this._versionManager.getBaseKeySet();
    }

    Set<String> getKeySet() {
        return this._versionManager.getKeySet();
    }

    ExpandVersion getPrimaryVersion(String key) {
        return this._versionManager.getPrimaryVersion(key);
    }

    ExpandVersion getVersion(String key) {
        return this._versionManager.getVersion(key);
    }

    ExpandVersionGroup getBaseVersionGroup(String key) {
        return this._versionManager.getBaseVersionGroup(key);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

