/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.git;

import com.caucho.env.git.GitWorkingTree;
import com.caucho.util.Hex;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.DeflaterOutputStream;

public class GitCommitTree {
    private GitWorkingTree _root = new GitWorkingTree();
    private HashMap<String, String> _sha1ToPathMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addFile(String treePath, int mode, Path filePath) throws IOException {
        ReadStream is = filePath.openRead();
        try {
            String string = this.addFile(treePath, mode, is, filePath.getLength());
            return string;
        }
        finally {
            is.close();
        }
    }

    public String addFile(String path, int mode, InputStream is, long length) throws IOException {
        String sha1 = GitCommitTree.calculateBlobDigest(is, length);
        this._root.addBlobPath(path, mode, sha1);
        this._sha1ToPathMap.put(sha1, path);
        return sha1;
    }

    public String findPath(String sha1) {
        return this._sha1ToPathMap.get(sha1);
    }

    public GitWorkingTree findTree(String path) {
        return this._root.findTreeRec(path);
    }

    public String commit() {
        return this._root.commit(this, "");
    }

    public String getDigest() {
        return this._root.getDigest();
    }

    void addCommitDir(String sha1, String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this._sha1ToPathMap.put(sha1, path);
    }

    public String[] getCommitList() {
        Object[] commitList = new String[this._sha1ToPathMap.size()];
        this._sha1ToPathMap.keySet().toArray(commitList);
        Arrays.sort(commitList);
        return commitList;
    }

    public static String calculateBlobDigest(InputStream is, long length) throws IOException {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update((byte)98);
            md.update((byte)108);
            md.update((byte)111);
            md.update((byte)98);
            md.update((byte)32);
            String lenString = String.valueOf(length);
            for (int i = 0; i < lenString.length(); ++i) {
                md.update((byte)lenString.charAt(i));
            }
            md.update((byte)0);
            byte[] buffer = tBuf.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                md.update(buffer, 0, len);
            }
            String string = Hex.toHex(md.digest());
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        finally {
            TempBuffer.free(tBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream writeBlob(InputStream is, long length) throws IOException {
        TempOutputStream os = new TempOutputStream();
        DeflaterOutputStream out = new DeflaterOutputStream(os);
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            int len;
            out.write(98);
            out.write(108);
            out.write(111);
            out.write(98);
            out.write(32);
            String lenString = String.valueOf(length);
            for (int i = 0; i < lenString.length(); ++i) {
                out.write(lenString.charAt(i));
            }
            out.write(0);
            byte[] buffer = tBuf.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, len);
            }
            out.close();
            ReadStream readStream = os.openRead();
            return readStream;
        }
        finally {
            TempBuffer.free(tBuf);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

