/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.git;

import com.caucho.env.git.GitCommit;
import com.caucho.env.git.GitObjectStream;
import com.caucho.env.git.GitTree;
import com.caucho.env.git.GitType;
import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectoryService;
import com.caucho.util.Alarm;
import com.caucho.util.Hex;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class GitService
extends AbstractResinService {
    private static final L10N L = new L10N(GitService.class);
    private static final Logger log = Logger.getLogger(GitService.class.getName());
    public static final int START_PRIORITY = 21;
    private Path _root;

    public GitService() {
    }

    public GitService(Path root) {
        this._root = root;
    }

    public static GitService getCurrent() {
        return ResinSystem.getCurrentService(GitService.class);
    }

    public static GitService create() {
        ResinSystem resinSystem = ResinSystem.getCurrent();
        if (resinSystem == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1} environment.", (Object)GitService.class.getSimpleName(), ResinSystem.class.getSimpleName()));
        }
        GitService git = resinSystem.getService(GitService.class);
        if (git == null) {
            git = new GitService();
            resinSystem.addServiceIfAbsent(git);
            git = resinSystem.getService(GitService.class);
        }
        return git;
    }

    public int getStartPriority() {
        return 21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this._root == null) {
            this._root = RootDirectoryService.getCurrentDataDirectory().lookup(".git");
        }
        if (this._root.lookup("HEAD").canRead()) {
            return;
        }
        this._root.mkdirs();
        this._root.lookup("refs").mkdir();
        this._root.lookup("refs/heads").mkdir();
        this._root.lookup("objects").mkdir();
        this._root.lookup("objects/info").mkdir();
        this._root.lookup("objects/pack").mkdir();
        this._root.lookup("branches").mkdir();
        this._root.lookup("tmp").mkdir();
        WriteStream out = this._root.lookup("HEAD").openWrite();
        try {
            out.println("ref: refs/heads/master");
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaster() {
        Path path = this._root.lookup("refs/heads/master");
        ReadStream is = path.openRead();
        try {
            String string = is.readLine();
            {
                Object var5_5 = null;
                is.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                Object var5_6 = null;
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitType objectType(String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        try {
            GitType gitType = is.getType();
            Object var5_4 = null;
            is.close();
            return gitType;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTag(String tag) {
        Path path = this._root.lookup("refs").lookup(tag);
        if (!path.canRead()) {
            return null;
        }
        ReadStream is = null;
        try {
            is = path.openRead();
            String hex = is.readLine();
            String string = hex.trim();
            Object var7_8 = null;
            if (is != null) {
                is.close();
            }
            return string;
        }
        catch (IOException e) {
            try {
                log.log(Level.FINE, e.toString(), e);
                String string = null;
                Object var7_9 = null;
                if (is != null) {
                    is.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_10 = null;
                    if (is == null) break block7;
                    is.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeTag(String tag, String hex) {
        block13: {
            Path path = this._root.lookup("refs").lookup(tag);
            try {
                path.getParent().mkdirs();
            }
            catch (IOException e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            WriteStream out = null;
            out = path.openWrite();
            out.println(hex);
            Object var7_6 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block13;
            }
            catch (Exception e2) {
                log.log(Level.FINEST, e2.toString(), e2);
            }
            break block13;
            {
                catch (IOException e) {
                    log.log(Level.FINE, e.toString(), e);
                    Object var7_7 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block13;
                    }
                    catch (Exception e2) {
                        log.log(Level.FINEST, e2.toString(), e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e2) {
                    log.log(Level.FINEST, e2.toString(), e2);
                }
                throw throwable;
            }
        }
    }

    public String[] listRefs(String dir) {
        try {
            Path path = this._root.lookup("refs").lookup(dir);
            if (path.isDirectory()) {
                return path.list();
            }
            return new String[0];
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return new String[0];
        }
    }

    public Path getRefPath(String path) {
        return this._root.lookup("refs").lookup(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitCommit parseCommit(String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        try {
            if (is.getType() != GitType.COMMIT) {
                throw new IOException(L.l("'{0}' is an unexpected type, expected 'commit'", (Object)is.getType()));
            }
            GitCommit gitCommit = is.parseCommit();
            Object var5_4 = null;
            is.close();
            return gitCommit;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitTree parseTree(String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        try {
            if (GitType.TREE != is.getType()) {
                throw new IOException(L.l("'{0}' is an unexpected type, expected 'tree'", (Object)is.getType()));
            }
            GitTree gitTree = is.parseTree();
            Object var5_4 = null;
            is.close();
            return gitTree;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
    }

    public InputStream openBlob(String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        if (is.getType() != GitType.BLOB) {
            is.close();
            throw new IOException(L.l("'{0}' is an unexpected type, expected 'blob'", (Object)is.getType()));
        }
        return is;
    }

    public void expandToPath(Path path, String sha1) throws IOException {
        long now = Alarm.getCurrentTime();
        this.expandToPath(path, sha1, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandToPath(Path path, String sha1, long now) throws IOException {
        GitObjectStream is = this.open(sha1);
        try {
            if (GitType.TREE == is.getType()) {
                GitTree tree = is.parseTree();
                is.close();
                this.expandTreeToPath(path, tree, now);
            } else if (GitType.BLOB == is.getType()) {
                WriteStream os = path.openWrite();
                try {
                    os.writeStream(is.getInputStream());
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    os.close();
                    throw throwable;
                }
                os.close();
                path.setLastModified(now);
            } else {
                throw new IOException(L.l("'{0}' is an unexpected type, expected 'blob' or 'tree'", (Object)is.getType()));
            }
            Object var10_10 = null;
            is.close();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            is.close();
            throw throwable;
        }
    }

    private void expandTreeToPath(Path path, GitTree tree, long now) throws IOException {
        path.mkdirs();
        for (GitTree.Entry entry : tree.entries()) {
            String name = entry.getName();
            this.expandToPath(path.lookup(name), entry.getSha1(), now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToFile(Path path, String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        try {
            if (GitType.BLOB != is.getType()) {
                throw new IOException(L.l("'{0}' is an unexpected type, expected 'blob'", (Object)is.getType()));
            }
            WriteStream os = path.openWrite();
            try {
                os.writeStream(is.getInputStream());
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                os.close();
                throw throwable;
            }
            os.close();
            Object var8_8 = null;
            is.close();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            is.close();
            throw throwable;
        }
    }

    public boolean contains(String hash) {
        String prefix = hash.substring(0, 2);
        String suffix = hash.substring(2);
        Path path = this._root.lookup("objects").lookup(prefix).lookup(suffix);
        return path.exists();
    }

    public GitObjectStream open(String sha1) throws IOException {
        String prefix = sha1.substring(0, 2);
        String suffix = sha1.substring(2);
        Path path = this._root.lookup("objects").lookup(prefix).lookup(suffix);
        return new GitObjectStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(Path path) throws IOException {
        String string;
        ReadStream is = path.openRead();
        try {
            TempOutputStream os = new TempOutputStream();
            String type = "blob";
            String hex = GitService.writeData(os, type, is, path.getLength());
            string = this.writeFile(os, hex);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ((InputStream)is).close();
            throw throwable;
        }
        ((InputStream)is).close();
        return string;
    }

    public String writeInputStream(InputStream is) throws IOException {
        TempStream tempOs = new TempStream();
        WriteStream out = new WriteStream(tempOs);
        out.writeStream(is);
        out.close();
        int length = tempOs.getLength();
        String type = "blob";
        TempOutputStream os = new TempOutputStream();
        String sha1 = GitService.writeData(os, type, tempOs.getInputStream(), length);
        return this.writeFile(os, sha1);
    }

    public String writeInputStream(InputStream is, long length) throws IOException {
        String type = "blob";
        TempOutputStream os = new TempOutputStream();
        String sha1 = GitService.writeData(os, type, is, length);
        return this.writeFile(os, sha1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeTree(GitTree tree) throws IOException {
        String string;
        TempOutputStream treeOut = new TempOutputStream();
        tree.toData(treeOut);
        int treeLength = treeOut.getLength();
        ReadStream is = treeOut.openRead();
        try {
            TempOutputStream os = new TempOutputStream();
            String type = "tree";
            String hex = GitService.writeData(os, type, is, treeLength);
            string = this.writeFile(os, hex);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((InputStream)is).close();
            throw throwable;
        }
        ((InputStream)is).close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeCommit(GitCommit commit) throws IOException {
        String string;
        Map<String, String> attr;
        TempStream commitOut = new TempStream();
        WriteStream out = new WriteStream(commitOut);
        out.print("tree ");
        out.println(commit.getTree());
        String parent = commit.getParent();
        if (parent != null) {
            out.print("parent ");
            out.println(parent);
        }
        if ((attr = commit.getMetaData()) != null) {
            ArrayList<String> keys = new ArrayList<String>(attr.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                out.print(key);
                out.print(' ');
                out.print(attr.get(key));
                out.println();
            }
        }
        out.println();
        if (commit.getMessage() != null) {
            out.println(commit.getMessage());
        }
        out.close();
        int commitLength = commitOut.getLength();
        ReadStream is = commitOut.openRead();
        try {
            TempOutputStream os = new TempOutputStream();
            String type = "commit";
            String hex = GitService.writeData(os, type, is, commitLength);
            string = this.writeFile(os, hex);
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            ((InputStream)is).close();
            throw throwable;
        }
        ((InputStream)is).close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(TempOutputStream os, String hex) throws IOException {
        Path objectPath = this.lookupPath(hex);
        if (objectPath.exists()) {
            return hex;
        }
        objectPath.getParent().mkdirs();
        Path tmpDir = this._root.lookup("tmp");
        tmpDir.mkdirs();
        Path tmp = this._root.lookup("tmp").lookup("tmp." + hex);
        WriteStream tmpOs = tmp.openWrite();
        try {
            tmpOs.writeStream(os.openRead());
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            tmpOs.close();
            throw throwable;
        }
        tmpOs.close();
        tmp.renameTo(objectPath);
        return hex;
    }

    public InputStream openRawGitFile(String sha1) throws IOException {
        Path objectPath = this.lookupPath(sha1);
        return objectPath.openRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeRawGitFile(String sha1, InputStream is) throws IOException {
        Path objectPath = this.lookupPath(sha1);
        if (objectPath.exists()) {
            return sha1;
        }
        objectPath.getParent().mkdirs();
        Path tmpDir = this._root.lookup("tmp");
        tmpDir.mkdirs();
        Path tmp = this._root.lookup("tmp").lookup("tmp." + sha1);
        try {
            block9: {
                try {
                    WriteStream tmpOut = tmp.openWrite();
                    try {
                        tmpOut.writeStream(is);
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        tmpOut.close();
                        throw throwable;
                    }
                    tmpOut.close();
                    String newHex = this.validate(tmp);
                    if (!sha1.equals(newHex)) {
                        throw new RuntimeException(L.l("{0}: file validation failed because sha-1 hash '{0}' does not match expected '{1}'", (Object)newHex, sha1));
                    }
                    tmp.renameTo(objectPath);
                    if (!log.isLoggable(Level.FINER)) break block9;
                    log.finer(this + " addRawGitFile " + sha1 + " " + objectPath);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            tmp.remove();
            throw throwable;
        }
        tmp.remove();
        return sha1;
    }

    private Path lookupPath(String sha1) {
        String prefix = sha1.substring(0, 2);
        String suffix = sha1.substring(2);
        return this._root.lookup("objects").lookup(prefix).lookup(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String validate(Path path) throws IOException, NoSuchAlgorithmException {
        ReadStream is = path.openRead();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            InflaterInputStream zin = new InflaterInputStream(is);
            DigestInputStream din = new DigestInputStream(zin, md);
            while (din.read() >= 0) {
            }
            din.close();
            byte[] digest = md.digest();
            String string = Hex.toHex(digest);
            Object var9_8 = null;
            is.close();
            return string;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            is.close();
            throw throwable;
        }
    }

    public static String writeData(OutputStream os, String type, InputStream is, long length) throws IOException {
        String string;
        TempBuffer buf = TempBuffer.allocate();
        try {
            int len;
            DeflaterOutputStream out = new DeflaterOutputStream(os);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            for (int i = 0; i < type.length(); ++i) {
                char ch = type.charAt(i);
                out.write(ch);
                md.update((byte)ch);
            }
            out.write(32);
            md.update((byte)32);
            String lengthString = String.valueOf(length);
            for (int i = 0; i < lengthString.length(); ++i) {
                char ch = lengthString.charAt(i);
                out.write(ch);
                md.update((byte)ch);
            }
            out.write(0);
            md.update((byte)0);
            long readLength = 0L;
            byte[] buffer = buf.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, len);
                md.update(buffer, 0, len);
                readLength += (long)len;
            }
            out.close();
            if (readLength != length) {
                throw new IOException(L.l("written length does not match data"));
            }
            string = Hex.toHex(md.digest());
            Object var15_16 = null;
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                TempBuffer.free(buf);
                throw throwable;
            }
        }
        TempBuffer.free(buf);
        return string;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._root + "]";
    }
}

