/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.jpa;

import com.caucho.amber.manager.AmberPersistenceProvider;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.CurrentLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ConfigProgram;
import com.caucho.env.jpa.ConfigJpaPersistenceUnit;
import com.caucho.env.jpa.ConfigPersistence;
import com.caucho.env.jpa.ConfigPersistenceUnit;
import com.caucho.env.jpa.PersistenceUnitManager;
import com.caucho.inject.Module;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentEnhancerListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.ScanClass;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.IoUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class PersistenceManager
implements ScanListener,
EnvironmentEnhancerListener {
    private static final Logger log = Logger.getLogger(PersistenceManager.class.getName());
    private static final EnvironmentLocal<PersistenceManager> _localManager = new EnvironmentLocal();
    private EnvironmentClassLoader _classLoader;
    private ClassLoader _tempLoader;
    private HashMap<String, PersistenceUnitManager> _persistenceUnitMap = new HashMap();
    private ArrayList<ConfigProgram> _unitDefaultList = new ArrayList();
    private HashMap<String, ArrayList<ConfigProgram>> _unitDefaultMap = new HashMap();
    private ArrayList<Path> _pendingRootList = new ArrayList();
    private HashMap<String, EntityManager> _persistenceContextMap = new HashMap();
    private ArrayList<LazyEntityManagerFactory> _pendingFactoryList = new ArrayList();

    private PersistenceManager(ClassLoader loader) {
        this._classLoader = Environment.getEnvironmentClassLoader(loader);
        _localManager.set(this, this._classLoader);
        this._tempLoader = this._classLoader.getNewTempClassLoader();
        this._classLoader.addScanListener(this);
        Environment.addEnvironmentListener(this, this._classLoader);
        try {
            if (this._classLoader instanceof DynamicClassLoader) {
                this._classLoader.make();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PersistenceManager create() {
        return PersistenceManager.create(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistenceManager create(ClassLoader loader) {
        EnvironmentLocal<PersistenceManager> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            PersistenceManager container = _localManager.getLevel(loader);
            if (container == null) {
                container = new PersistenceManager(loader);
                _localManager.set(container, loader);
            }
            return container;
        }
    }

    public static PersistenceManager getCurrent() {
        return PersistenceManager.getCurrent(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistenceManager getCurrent(ClassLoader loader) {
        EnvironmentLocal<PersistenceManager> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            return _localManager.get(loader);
        }
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._classLoader;
    }

    public ClassLoader getTempClassLoader() {
        return this._tempLoader;
    }

    public void addPersistenceUnitDefault(ConfigProgram program) {
        this._unitDefaultList.add(program);
    }

    public ArrayList<ConfigProgram> getPersistenceUnitDefaults() {
        return this._unitDefaultList;
    }

    void addPersistenceUnit(String name, ConfigJpaPersistenceUnit configJpaPersistenceUnit) {
        PersistenceUnitManager pUnit = this.createPersistenceUnit(name);
        if (pUnit.getRoot() == null) {
            pUnit.setRoot(configJpaPersistenceUnit.getPath());
        }
        pUnit.addOverrideProgram(configJpaPersistenceUnit.getProgram());
    }

    public void addPersistenceUnitProxy(String name, ArrayList<ConfigProgram> program) {
        ArrayList<ConfigProgram> oldProgram = this._unitDefaultMap.get(name);
        if (oldProgram == null) {
            oldProgram = new ArrayList();
        }
        oldProgram.addAll(program);
        this._unitDefaultMap.put(name, oldProgram);
    }

    public ArrayList<ConfigProgram> getProxyProgram(String name) {
        return this._unitDefaultMap.get(name);
    }

    public Class<?> loadTempClass(String name) throws ClassNotFoundException {
        return Class.forName(name, false, this.getTempClassLoader());
    }

    public void init() {
    }

    public void start() {
        this.configurePersistenceRoots();
        this.startPersistenceUnits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurePersistenceRoots() {
        ArrayList<Path> rootList = new ArrayList<Path>();
        ArrayList<Path> arrayList = this._pendingRootList;
        synchronized (arrayList) {
            rootList.addAll(this._pendingRootList);
            this._pendingRootList.clear();
        }
        for (Path root : rootList) {
            this.parsePersistenceConfig(root);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePersistenceConfig(Path root) {
        Path persistenceXml = root.lookup("META-INF/persistence.xml");
        if (root.getFullPath().endsWith("WEB-INF/classes/") && !persistenceXml.canRead()) {
            persistenceXml = root.lookup("../persistence.xml");
        }
        if (!persistenceXml.canRead()) {
            return;
        }
        persistenceXml.setUserPath(persistenceXml.getURL());
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " parsing " + persistenceXml.getURL());
        }
        ReadStream is = null;
        try {
            try {
                is = persistenceXml.openRead();
                ConfigPersistence persistence = new ConfigPersistence(root);
                new Config().configure((Object)persistence, (InputStream)is, "com/caucho/amber/cfg/persistence-31.rnc");
                for (ConfigPersistenceUnit unitConfig : persistence.getUnitList()) {
                    PersistenceUnitManager pUnit = this.createPersistenceUnit(unitConfig.getName());
                    if (pUnit.getRoot() == null) {
                        pUnit.setRoot(unitConfig.getRoot());
                    }
                    if (unitConfig.getVersion() != null) {
                        pUnit.setVersion(unitConfig.getVersion());
                    }
                    pUnit.setPersistenceXmlProgram(unitConfig.getProgram());
                }
                Object var9_10 = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw LineConfigException.create(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (is == null) return;
        ((InputStream)is).close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceUnitManager createPersistenceUnit(String name) {
        PersistenceUnitManager unit;
        HashMap<String, PersistenceUnitManager> hashMap = this._persistenceUnitMap;
        synchronized (hashMap) {
            unit = this._persistenceUnitMap.get(name);
            if (unit != null) {
                return unit;
            }
            unit = new PersistenceUnitManager(this, name);
            this._persistenceUnitMap.put(name, unit);
        }
        this.registerPersistenceUnit(unit);
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPersistenceUnits() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            ArrayList<PersistenceUnitManager> pUnitList = new ArrayList<PersistenceUnitManager>();
            HashMap<String, PersistenceUnitManager> hashMap = this._persistenceUnitMap;
            synchronized (hashMap) {
                pUnitList.addAll(this._persistenceUnitMap.values());
            }
            for (PersistenceUnitManager pUnit : pUnitList) {
                pUnit.start();
            }
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private void registerPersistenceUnit(PersistenceUnitManager pUnit) {
        try {
            InjectManager beanManager = InjectManager.create(this._classLoader);
            BeanBuilder<EntityManagerFactory> emfFactory = beanManager.createBeanFactory(EntityManagerFactory.class);
            emfFactory.qualifier((Annotation)CurrentLiteral.CURRENT);
            emfFactory.qualifier((Annotation)Names.create(pUnit.getName()));
            beanManager.addBean(emfFactory.singleton(pUnit.getEntityManagerFactoryProxy()));
            BeanBuilder<EntityManager> emFactory = beanManager.createBeanFactory(EntityManager.class);
            emFactory.qualifier((Annotation)CurrentLiteral.CURRENT);
            emFactory.qualifier((Annotation)Names.create(pUnit.getName()));
            beanManager.addBean(emFactory.singleton(pUnit.getEntityManagerJtaProxy()));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    void addProviderUnit(ConfigPersistenceUnit unit) {
        try {
            Class<Object> cl = unit.getProvider();
            if (cl == null) {
                cl = this.getServiceProvider();
            }
            if (cl == null) {
                cl = AmberPersistenceProvider.class;
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("JPA PersistenceUnit[" + unit.getName() + "] handled by " + cl.getName());
            }
            PersistenceProvider provider = (PersistenceProvider)cl.newInstance();
            String unitName = unit.getName();
            Object props = null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    Class<?> getServiceProvider() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> e = loader.getResources("META-INF/services/" + PersistenceProvider.class.getName());
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                Class<?> providerClass = this.loadProvider(url);
                if (providerClass == null || providerClass.equals(AmberPersistenceProvider.class)) continue;
                return providerClass;
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> loadProvider(URL url) {
        InputStream is;
        block8: {
            Class<?> clazz;
            block7: {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                is = null;
                try {
                    try {
                        String line;
                        is = url.openStream();
                        ReadStream in = Vfs.openRead(is);
                        while ((line = in.readLine()) != null) {
                            if ("".equals(line = line.trim()) || line.startsWith("#")) continue;
                            clazz = Class.forName(line, false, loader);
                            Object var8_8 = null;
                            break block7;
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        log.log(Level.FINE, e.toString(), e);
                        Object var8_10 = null;
                        IoUtil.close(is);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    IoUtil.close(is);
                    throw throwable;
                }
            }
            IoUtil.close(is);
            return clazz;
        }
        Object var8_9 = null;
        IoUtil.close(is);
        return null;
    }

    @Override
    public int getScanPriority() {
        return 0;
    }

    @Override
    public boolean isRootScannable(Path root, String packageRoot) {
        if (root.lookup("META-INF/persistence.xml").canRead() || root.getFullPath().endsWith("WEB-INF/classes/") && root.lookup("../persistence.xml").canRead()) {
            this._pendingRootList.add(root);
        }
        return false;
    }

    @Override
    public ScanClass scanClass(Path root, String packageRoot, String className, int modifiers) {
        return null;
    }

    @Override
    public boolean isScanMatchAnnotation(CharBuffer annotationName) {
        return false;
    }

    @Override
    public void classMatchEvent(EnvironmentClassLoader loader, Path root, String className) {
    }

    @Override
    public void environmentConfigureEnhancer(EnvironmentClassLoader loader) {
        this.configurePersistenceRoots();
        this.startPersistenceUnits();
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
        this.configurePersistenceRoots();
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
        this.configurePersistenceRoots();
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
    }

    private EntityManagerFactory getEntityManagerFactory(String unitName) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._classLoader.getId() + "]";
    }

    class LazyEntityManagerFactory {
        private final ConfigPersistenceUnit _unit;
        private final PersistenceProvider _provider;
        private final Map _props;

        LazyEntityManagerFactory(ConfigPersistenceUnit unit, PersistenceProvider provider, Map props) {
            this._unit = unit;
            this._provider = provider;
            this._props = props;
        }

        void init() {
        }
    }
}

