/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.ActiveSensor;
import java.util.concurrent.atomic.AtomicLong;

public final class ActiveMeter
extends AbstractMeter
implements ActiveSensor {
    private final AtomicLong _activeCount = new AtomicLong();
    private final AtomicLong _activeCountMax = new AtomicLong();
    private final AtomicLong _totalCount = new AtomicLong();
    private long _lastTotal;

    public ActiveMeter(String name) {
        super(name);
    }

    public final void start() {
        long max;
        long activeCount = this._activeCount.incrementAndGet();
        this._totalCount.incrementAndGet();
        while ((max = this._activeCountMax.get()) < activeCount && !this._activeCountMax.compareAndSet(max, activeCount)) {
        }
    }

    public final void end() {
        this._activeCount.decrementAndGet();
    }

    public AbstractMeter createMax(String name) {
        return new MaxProbe(name);
    }

    public AbstractMeter createTotal(String name) {
        return new TotalProbe(name);
    }

    public final double sampleActive() {
        return this._activeCount.get();
    }

    public final double sampleMax() {
        return this._activeCountMax.getAndSet(this._activeCount.get());
    }

    public final double sample() {
        long totalCount = this._totalCount.get();
        long lastTotal = this._lastTotal;
        this._lastTotal = totalCount;
        return totalCount - lastTotal;
    }

    class TotalProbe
    extends AbstractMeter {
        TotalProbe(String name) {
            super(name);
        }

        public double sample() {
            return this.sample();
        }
    }

    class MaxProbe
    extends AbstractMeter {
        MaxProbe(String name) {
            super(name);
        }

        public double sample() {
            return ActiveMeter.this.sampleMax();
        }
    }
}

