/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.config.ConfigException;
import com.caucho.env.meter.AbstractMeter;
import com.caucho.jmx.Jmx;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class JmxDeltaMeter
extends AbstractMeter {
    private static final Logger log = Logger.getLogger(JmxDeltaMeter.class.getName());
    private MBeanServer _server;
    private ObjectName _objectName;
    private String _attribute;
    private double _lastValue;

    public JmxDeltaMeter(String name, String objectName, String attribute) {
        super(name);
        try {
            this._objectName = new ObjectName(objectName);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        this._attribute = attribute;
        this._server = Jmx.getGlobalMBeanServer();
    }

    public double sample() {
        try {
            double lastValue;
            Object objValue = this._server.getAttribute(this._objectName, this._attribute);
            if (objValue == null) {
                return 0.0;
            }
            this._lastValue = lastValue = this._lastValue;
            double value = ((Number)objValue).doubleValue();
            return value - lastValue;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return 0.0;
        }
    }
}

