/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.TimeSensor;
import java.util.concurrent.atomic.AtomicLong;

public final class TimeMeter
extends AbstractMeter
implements TimeSensor {
    private final AtomicLong _count = new AtomicLong();
    private final AtomicLong _time = new AtomicLong();

    public TimeMeter(String name) {
        super(name);
    }

    public final void add(long time) {
        this._count.incrementAndGet();
        this._time.addAndGet(time);
    }

    public final double sample() {
        long count = this._count.getAndSet(0L);
        long time = this._time.getAndSet(0L);
        if (count == 0L) {
            return 0.0;
        }
        return (double)time / (double)count;
    }
}

