/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.TimeSensor;
import com.caucho.util.Alarm;
import java.util.concurrent.atomic.AtomicLong;

public final class TimeRangeMeter
extends AbstractMeter
implements TimeSensor {
    private final double _scale;
    private final AtomicLong _activeCount = new AtomicLong();
    private final AtomicLong _count = new AtomicLong();
    private final AtomicLong _time = new AtomicLong();
    private final AtomicLong _timeMax = new AtomicLong();
    private final AtomicLong _lastAvgCount = new AtomicLong();
    private final AtomicLong _lastAvgTime = new AtomicLong();
    private final AtomicLong _lastCount = new AtomicLong();

    public TimeRangeMeter(String name) {
        super(name);
        this._scale = 1.0;
    }

    public AbstractMeter createCount(String name) {
        return new TimeRangeCountProbe(name);
    }

    public AbstractMeter createActiveCount(String name) {
        return new TimeRangeActiveCountProbe(name);
    }

    public AbstractMeter createMax(String name) {
        return new TimeRangeMaxProbe(name);
    }

    public final long start() {
        long startTime = Alarm.getCurrentTime();
        this._activeCount.incrementAndGet();
        return startTime;
    }

    public final void add(long startTime) {
        this._activeCount.decrementAndGet();
        long time = Alarm.getCurrentTime() - startTime;
        this._count.incrementAndGet();
        this._time.addAndGet(time);
        long max = this._timeMax.get();
        while (max < time) {
            this._timeMax.compareAndSet(max, time);
            max = this._timeMax.get();
        }
    }

    public final double sample() {
        long count = this._count.get();
        long lastCount = this._lastAvgCount.getAndSet(count);
        long time = this._time.get();
        long lastTime = this._lastAvgTime.getAndSet(time);
        if (count == lastCount) {
            return 0.0;
        }
        return this._scale * (double)(time - lastTime) / (double)(count - lastCount);
    }

    public final double sampleCount() {
        long count = this._count.get();
        long lastCount = this._lastCount.getAndSet(count);
        return count - lastCount;
    }

    public final double sampleMax() {
        long max = this._timeMax.getAndSet(0L);
        return this._scale * (double)max;
    }

    class TimeRangeMaxProbe
    extends AbstractMeter {
        TimeRangeMaxProbe(String name) {
            super(name);
        }

        public double sample() {
            return TimeRangeMeter.this.sampleMax();
        }
    }

    class TimeRangeActiveCountProbe
    extends AbstractMeter {
        TimeRangeActiveCountProbe(String name) {
            super(name);
        }

        public double sample() {
            return TimeRangeMeter.this._activeCount.get();
        }
    }

    class TimeRangeCountProbe
    extends AbstractMeter {
        TimeRangeCountProbe(String name) {
            super(name);
        }

        public double sample() {
            return TimeRangeMeter.this.sampleCount();
        }
    }
}

