/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.repository;

import com.caucho.env.git.GitCommit;
import com.caucho.env.git.GitCommitJar;
import com.caucho.env.git.GitService;
import com.caucho.env.git.GitTree;
import com.caucho.env.git.GitType;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.env.repository.Repository;
import com.caucho.env.repository.RepositoryException;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.env.repository.RepositoryTagListener;
import com.caucho.env.repository.RepositoryTagMap;
import com.caucho.server.admin.GitJarStreamSource;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepository
implements Repository,
RepositorySpi {
    private static final Logger log = Logger.getLogger(AbstractRepository.class.getName());
    private static final L10N L = new L10N(AbstractRepository.class);
    private String _repositoryTag = "resin/repository/root";
    private RepositoryTagMap _tagMap = new RepositoryTagMap();
    private ConcurrentHashMap<String, CopyOnWriteArrayList<RepositoryTagListener>> _tagListenerMap = new ConcurrentHashMap();

    protected AbstractRepository() {
    }

    public void init() {
    }

    public void start() {
        this.checkForUpdate();
    }

    protected String getRepositoryTag() {
        return this._repositoryTag;
    }

    @Override
    public void checkForUpdate() {
        this.update(this.getRepositoryRootHash());
    }

    protected boolean update(String sha1) {
        String oldSha1 = this._tagMap.getCommitHash();
        if (sha1 == null || sha1.equals(oldSha1)) {
            return true;
        }
        this.updateLoad(sha1);
        return false;
    }

    protected void updateLoad(String sha1) {
        this.updateTagMap(sha1);
    }

    protected void updateTagMap(String sha1) {
        try {
            RepositoryTagMap tagMap = new RepositoryTagMap(this, sha1);
            this.setTagMap(tagMap);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    protected String getCommitHash() {
        return this._tagMap.getCommitHash();
    }

    @Override
    public Map<String, RepositoryTagEntry> getTagMap() {
        return this._tagMap.getTagMap();
    }

    @Override
    public String getTagContentHash(String tag) {
        RepositoryTagEntry entry = this.getTagMap().get(tag);
        if (entry != null) {
            return entry.getRoot();
        }
        return null;
    }

    @Override
    public abstract boolean putTag(String var1, String var2, Map<String, String> var3);

    @Override
    public abstract boolean removeTag(String var1, Map<String, String> var2);

    @Override
    public String commitArchive(CommitBuilder commit, Path archivePath) {
        commit.validate();
        String contentHash = this.addArchive(archivePath);
        if (this.putTag(commit.getId(), contentHash, commit.getAttributes())) {
            return contentHash;
        }
        return null;
    }

    @Override
    public String commitArchive(CommitBuilder commit, InputStream is) {
        commit.validate();
        String contentHash = this.addArchive(is);
        if (this.putTag(commit.getId(), contentHash, commit.getAttributes())) {
            return contentHash;
        }
        return null;
    }

    @Override
    public String commitPath(CommitBuilder commit, Path directoryPath) {
        commit.validate();
        String contentHash = this.addPath(directoryPath);
        if (this.putTag(commit.getId(), contentHash, commit.getAttributes())) {
            return contentHash;
        }
        return null;
    }

    @Override
    public boolean removeTag(CommitBuilder commit) {
        commit.validate();
        return this.removeTag(commit.getId(), commit.getAttributes());
    }

    protected RepositoryTagMap addTagData(String tagName, String contentHash, Map<String, String> commitMetaData) {
        try {
            this.checkForUpdate();
            RepositoryTagMap repositoryTagMap = this._tagMap;
            Map<String, RepositoryTagEntry> tagMap = repositoryTagMap.getTagMap();
            if (!this.validateHash(contentHash)) {
                throw new RepositoryException(L.l("'{0}' has invalid or missing repository content", contentHash));
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " committing " + tagName + "\n  '" + commitMetaData.get("message") + "'\n  " + contentHash);
            }
            String parent = null;
            RepositoryTagEntry entry = new RepositoryTagEntry(this, tagName, contentHash, parent, commitMetaData);
            TreeMap<String, RepositoryTagEntry> newTagMap = new TreeMap<String, RepositoryTagEntry>(tagMap);
            newTagMap.put(tagName, entry);
            RepositoryTagMap newDeployTagMap = new RepositoryTagMap(this, repositoryTagMap, newTagMap);
            if (this._tagMap == repositoryTagMap) {
                return newDeployTagMap;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        return null;
    }

    protected RepositoryTagMap removeTagData(String tagName, Map<String, String> commitMetaData) {
        try {
            if (tagName == null) {
                throw new NullPointerException();
            }
            this.checkForUpdate();
            RepositoryTagMap repositoryTagMap = this._tagMap;
            Map<String, RepositoryTagEntry> tagMap = repositoryTagMap.getTagMap();
            RepositoryTagEntry oldEntry = tagMap.get(tagName);
            if (oldEntry == null) {
                return repositoryTagMap;
            }
            TreeMap<String, RepositoryTagEntry> newTagMap = new TreeMap<String, RepositoryTagEntry>(tagMap);
            newTagMap.remove(tagName);
            RepositoryTagMap newDeployTagMap = new RepositoryTagMap(this, repositoryTagMap, newTagMap);
            if (this._tagMap == repositoryTagMap) {
                return newDeployTagMap;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setTagMap(RepositoryTagMap tagMap) {
        RepositoryTagMap oldTagMap = null;
        AbstractRepository abstractRepository = this;
        synchronized (abstractRepository) {
            oldTagMap = this._tagMap;
            if (tagMap.getSequence() <= oldTagMap.getSequence()) {
                return false;
            }
            this._tagMap = tagMap;
            this.setRepositoryRootHash(tagMap.getCommitHash());
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " updating deployment " + tagMap);
        }
        this.notifyTagListeners(oldTagMap.getTagMap(), tagMap.getTagMap());
        return true;
    }

    private void notifyTagListeners(Map<String, RepositoryTagEntry> oldTagMap, Map<String, RepositoryTagEntry> newTagMap) {
        for (Map.Entry<String, RepositoryTagEntry> entry : newTagMap.entrySet()) {
            String tag = entry.getKey();
            RepositoryTagEntry newEntry = entry.getValue();
            RepositoryTagEntry oldEntry = oldTagMap.get(tag);
            if (oldEntry == null) {
                this.onTagChange(tag);
                continue;
            }
            if (newEntry.getTagEntryHash().equals(oldEntry.getTagEntryHash())) continue;
            this.onTagChange(tag);
        }
        for (String tag : oldTagMap.keySet()) {
            if (newTagMap.containsKey(tag)) continue;
            this.onTagChange(tag);
        }
    }

    @Override
    public void addListener(String tag, RepositoryTagListener listener) {
        CopyOnWriteArrayList<RepositoryTagListener> listeners = this._tagListenerMap.get(tag);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList();
            this._tagListenerMap.putIfAbsent(tag, listeners);
            listeners = this._tagListenerMap.get(tag);
        }
        listeners.add(listener);
    }

    @Override
    public void removeListener(String tag, RepositoryTagListener listener) {
        CopyOnWriteArrayList<RepositoryTagListener> listeners = this._tagListenerMap.get(tag);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }

    private void onTagChange(String tag) {
        int p = tag.lastIndexOf(47);
        if (p >= 0) {
            this.onTagChange(tag.substring(0, p));
        } else if (!tag.isEmpty()) {
            this.onTagChange("");
        }
        CopyOnWriteArrayList<RepositoryTagListener> listeners = this._tagListenerMap.get(tag);
        if (listeners != null) {
            for (RepositoryTagListener listener : listeners) {
                listener.onTagChange(tag);
            }
        }
    }

    @Override
    public abstract String getRepositoryRootHash();

    @Override
    public abstract void setRepositoryRootHash(String var1);

    @Override
    public abstract boolean exists(String var1);

    @Override
    public abstract GitType getType(String var1);

    @Override
    public final boolean isBlob(String sha1) {
        return GitType.BLOB == this.getType(sha1);
    }

    @Override
    public final boolean isTree(String sha1) {
        return GitType.TREE == this.getType(sha1);
    }

    @Override
    public final boolean isCommit(String sha1) {
        return GitType.COMMIT == this.getType(sha1);
    }

    @Override
    public boolean validateHash(String sha1) throws IOException {
        GitType type = this.getType(sha1);
        if (type == GitType.BLOB) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this + " valid " + (Object)((Object)type) + " " + sha1);
            }
            return true;
        }
        if (type == GitType.COMMIT) {
            GitCommit commit = this.readCommit(sha1);
            if (commit == null) {
                return false;
            }
            return this.validateHash(commit.getTree());
        }
        if (type == GitType.TREE) {
            GitTree tree = this.readTree(sha1);
            for (GitTree.Entry entry : tree.entries()) {
                if (this.validateHash(entry.getSha1())) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " invalid " + entry);
                }
                return false;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this + " valid " + (Object)((Object)type) + " " + sha1);
            }
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " invalid " + sha1);
        }
        return false;
    }

    @Override
    public String addPath(Path path) {
        try {
            return this.addPathRec(path);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addPathRec(Path path) throws IOException {
        if (path.isFile()) {
            long length = path.getLength();
            ReadStream is = null;
            try {
                is = path.openRead();
                String hash = this.addBlob(is, length);
                if (hash == null) {
                    throw new NullPointerException();
                }
                String string = hash;
                return string;
            }
            finally {
                IoUtil.close(is);
            }
        }
        GitTree tree = new GitTree();
        for (String fileName : path.list()) {
            Path subPath = path.lookup(fileName);
            String subHash = this.addPathRec(subPath);
            tree.addEntry(fileName, 775, subHash);
        }
        String hash = this.addTree(tree);
        if (hash == null) {
            throw new NullPointerException();
        }
        return hash;
    }

    @Override
    public String addArchive(Path path) {
        GitCommitJar commit = null;
        try {
            commit = new GitCommitJar(path);
            String string = this.addArchive(commit);
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        finally {
            if (commit != null) {
                commit.close();
            }
        }
    }

    public String addArchive(InputStream is) {
        GitCommitJar commit = null;
        try {
            commit = new GitCommitJar(is);
            String string = this.addArchive(commit);
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        finally {
            if (commit != null) {
                commit.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addArchive(GitCommitJar commit) throws IOException {
        for (String hash : commit.getCommitList()) {
            GitJarStreamSource gitSource = new GitJarStreamSource(hash, commit);
            if (this.exists(hash)) continue;
            InputStream is = gitSource.openInputStream();
            try {
                this.writeRawGitFile(hash, is);
            }
            finally {
                is.close();
            }
        }
        return commit.getDigest();
    }

    @Override
    public String addBlob(InputStream is, long length) throws IOException {
        String type = "blob";
        TempOutputStream os = new TempOutputStream();
        String hash = GitService.writeData(os, type, is, length);
        this.writeRawGitFile(hash, os.openInputStream());
        return hash;
    }

    @Override
    public abstract InputStream openBlob(String var1) throws IOException;

    @Override
    public abstract GitTree readTree(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addTree(GitTree tree) throws IOException {
        TempOutputStream treeOut = new TempOutputStream();
        tree.toData(treeOut);
        int treeLength = treeOut.getLength();
        ReadStream is = treeOut.openRead();
        try {
            TempOutputStream os = new TempOutputStream();
            String type = "tree";
            String contentHash = GitService.writeData(os, type, is, treeLength);
            this.writeRawGitFile(contentHash, os.openInputStream());
            String string = contentHash;
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    @Override
    public abstract GitCommit readCommit(String var1) throws IOException;

    @Override
    public abstract String addCommit(GitCommit var1) throws IOException;

    @Override
    public abstract InputStream openRawGitFile(String var1) throws IOException;

    @Override
    public abstract void writeRawGitFile(String var1, InputStream var2) throws IOException;

    @Override
    public abstract void writeBlobToStream(String var1, OutputStream var2);

    @Override
    public abstract void expandToPath(String var1, Path var2);

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._repositoryTag + "]";
    }
}

