/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.repository;

import com.caucho.env.repository.AbstractRepository;
import com.caucho.env.repository.FileRepository;
import com.caucho.env.repository.Repository;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.util.L10N;

public class RepositoryService
extends AbstractResinService {
    private static final L10N L = new L10N(RepositoryService.class);
    public static final int START_PRIORITY = 46;
    private AbstractRepository _repository;

    public RepositoryService(AbstractRepository repository) {
        this._repository = repository;
        if (repository == null) {
            throw new NullPointerException();
        }
    }

    public RepositoryService() {
        this(new FileRepository());
    }

    public static RepositoryService getCurrent() {
        return ResinSystem.getCurrentService(RepositoryService.class);
    }

    public static RepositoryService create() {
        ResinSystem system = ResinSystem.getCurrent();
        if (system == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1}", (Object)RepositoryService.class.getSimpleName(), ResinSystem.class.getSimpleName()));
        }
        RepositoryService service = system.getService(RepositoryService.class);
        if (service == null) {
            service = new RepositoryService();
            system.addServiceIfAbsent(service);
            service = system.getService(RepositoryService.class);
        }
        return service;
    }

    public static Repository getCurrentRepository() {
        RepositoryService service = RepositoryService.getCurrent();
        if (service == null) {
            throw new IllegalStateException(L.l("RepositoryService is not available in this context"));
        }
        return service.getRepository();
    }

    public static RepositorySpi getCurrentRepositorySpi() {
        RepositoryService service = RepositoryService.getCurrent();
        if (service == null) {
            throw new IllegalStateException(L.l("RepositoryService is not available in this context"));
        }
        return service.getRepositorySpi();
    }

    public Repository getRepository() {
        return this._repository;
    }

    public RepositorySpi getRepositorySpi() {
        return this._repository;
    }

    public int getStartPriority() {
        return 46;
    }

    public void start() {
        this._repository.start();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._repository + "]";
    }
}

