/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.shutdown;

import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.warning.WarningService;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.util.Alarm;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShutdownService
extends AbstractResinService {
    private static final Logger log = Logger.getLogger(ShutdownService.class.getName());
    public static final int START_PRIORITY = 1;
    private static final AtomicReference<ShutdownService> _activeService = new AtomicReference();
    private long _shutdownWaitMax = 60000L;
    private WeakReference<ResinSystem> _resinSystemRef;
    private WarningService _warningService;
    private Lifecycle _lifecycle = new Lifecycle();
    private FailSafeHaltThread _failSafeHaltThread;
    private ShutdownThread _shutdownThread;
    private boolean _isEmbedded;
    private boolean _isDumpHeapOnExit;

    public ShutdownService(ResinSystem resinSystem) {
        this(resinSystem, Alarm.isTest());
    }

    public ShutdownService(ResinSystem resinSystem, boolean isEmbedded) {
        this._resinSystemRef = new WeakReference<ResinSystem>(resinSystem);
        this._warningService = WarningService.create(resinSystem);
        this._isEmbedded = isEmbedded;
    }

    public static ShutdownService getCurrent() {
        return ResinSystem.getCurrentService(ShutdownService.class);
    }

    public long getShutdownWaitMax() {
        return this._shutdownWaitMax;
    }

    public void setShutdownWaitTime(long shutdownTime) {
        this._shutdownWaitMax = shutdownTime;
    }

    public LifecycleState getLifecycleState() {
        return this._lifecycle.getState();
    }

    public static void shutdownActive(ExitCode exitCode, String msg) {
        ShutdownService shutdown = _activeService.get();
        if (shutdown != null) {
            shutdown.shutdown(exitCode, msg);
            return;
        }
        shutdown = ShutdownService.getCurrent();
        if (shutdown != null) {
            shutdown.shutdown(exitCode, msg);
            return;
        }
        log.warning("ShutdownService is not active");
        System.out.println("ShutdownService is not active");
    }

    public void shutdown(ExitCode exitCode, String msg) {
        if (exitCode == ExitCode.MEMORY) {
            this._isDumpHeapOnExit = true;
        }
        this.startFailSafeShutdown(msg);
        ShutdownThread shutdownThread = this._shutdownThread;
        if (shutdownThread != null) {
            shutdownThread.startShutdown(exitCode);
            if (!this._isEmbedded) {
                try {
                    Thread.sleep(900000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.println("Shutdown timeout");
                System.exit(exitCode.ordinal());
            }
        } else {
            this.shutdownImpl(exitCode);
        }
    }

    public void startFailSafeShutdown(String msg) {
        FailSafeHaltThread haltThread = this._failSafeHaltThread;
        if (haltThread != null) {
            haltThread.startShutdown();
        }
        this._warningService.warning(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownImpl(ExitCode exitCode) {
        FailSafeHaltThread haltThread = this._failSafeHaltThread;
        if (haltThread != null) {
            haltThread.startShutdown();
        }
        try {
            if (this._isDumpHeapOnExit) {
                this.dumpHeapOnExit();
            }
            try {
                block12: {
                    try {
                        ResinSystem resinSystem = (ResinSystem)this._resinSystemRef.get();
                        if (resinSystem == null) break block12;
                        resinSystem.destroy();
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        Object var5_6 = null;
                        this._resinSystemRef = null;
                    }
                }
                Object var5_5 = null;
                this._resinSystemRef = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this._resinSystemRef = null;
                throw throwable;
            }
            Object var7_9 = null;
            this._lifecycle.toDestroy();
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this._lifecycle.toDestroy();
            if (exitCode == null) {
                exitCode = ExitCode.FAIL_SAFE_HALT;
            }
            System.err.println("\nShutdown Resin reason: " + (Object)((Object)exitCode) + "\n");
            log.warning("Shutdown Resin reason: " + (Object)((Object)exitCode));
            if (!this._isEmbedded) {
                System.exit(exitCode.ordinal());
            }
            throw throwable;
        }
        if (exitCode == null) {
            exitCode = ExitCode.FAIL_SAFE_HALT;
        }
        System.err.println("\nShutdown Resin reason: " + (Object)((Object)exitCode) + "\n");
        log.warning("Shutdown Resin reason: " + (Object)((Object)exitCode));
        if (!this._isEmbedded) {
            System.exit(exitCode.ordinal());
        }
    }

    private ResinSystem getResinSystem() {
        WeakReference<ResinSystem> resinSystemRef = this._resinSystemRef;
        if (resinSystemRef != null) {
            return (ResinSystem)resinSystemRef.get();
        }
        return null;
    }

    public void dumpHeapOnExit() {
    }

    public void dumpThreads() {
    }

    public int getStartPriority() {
        return 1;
    }

    public void start() {
        this._lifecycle.toActive();
        if (!this._isEmbedded) {
            _activeService.compareAndSet(null, this);
        }
        if (!Alarm.isTest() && !this._isEmbedded) {
            this._failSafeHaltThread = new FailSafeHaltThread();
            this._failSafeHaltThread.start();
        }
        this._shutdownThread = new ShutdownThread();
        this._shutdownThread.setDaemon(true);
        this._shutdownThread.start();
    }

    public void stop() {
        ShutdownThread shutdownThread;
        this._lifecycle.toDestroy();
        _activeService.compareAndSet(this, null);
        FailSafeHaltThread failSafeThread = this._failSafeHaltThread;
        if (failSafeThread != null) {
            failSafeThread.wake();
        }
        if ((shutdownThread = this._shutdownThread) != null) {
            shutdownThread.wake();
        }
    }

    public void destroy() {
        this._lifecycle.toDestroy();
    }

    public String toString() {
        ResinSystem resinSystem = this.getResinSystem();
        if (resinSystem != null) {
            return this.getClass().getSimpleName() + "[id=" + resinSystem.getId() + "]";
        }
        return this.getClass().getSimpleName() + "[closed]";
    }

    class FailSafeHaltThread
    extends Thread {
        private volatile boolean _isShutdown;

        FailSafeHaltThread() {
            this.setName("resin-fail-safe-halt");
            this.setDaemon(true);
        }

        void startShutdown() {
            this._isShutdown = true;
            this.wake();
        }

        void wake() {
            LockSupport.unpark(this);
        }

        public void run() {
            long now;
            while (!this._isShutdown && ShutdownService.this._lifecycle.isActive()) {
                try {
                    Thread.interrupted();
                    LockSupport.park();
                }
                catch (Exception e) {}
            }
            if (!ShutdownService.this._lifecycle.isActive()) {
                return;
            }
            long expire = System.currentTimeMillis() + ShutdownService.this._shutdownWaitMax;
            while ((now = System.currentTimeMillis()) < expire) {
                try {
                    Thread.interrupted();
                    Thread.sleep(expire - now);
                }
                catch (Exception e) {}
            }
            if (ShutdownService.this._lifecycle.isActive()) {
                Runtime.getRuntime().halt(ExitCode.FAIL_SAFE_HALT.ordinal());
            }
        }
    }

    class ShutdownThread
    extends Thread {
        private AtomicReference<ExitCode> _shutdownExitCode = new AtomicReference();

        ShutdownThread() {
            this.setName("resin-shutdown");
            this.setDaemon(true);
        }

        void startShutdown(ExitCode exitCode) {
            this._shutdownExitCode.compareAndSet(null, exitCode);
            this.wake();
        }

        void wake() {
            LockSupport.unpark(this);
        }

        public void run() {
            while (this._shutdownExitCode.get() == null && ShutdownService.this._lifecycle.isActive()) {
                try {
                    Thread.interrupted();
                    LockSupport.park();
                }
                catch (Exception e) {}
            }
            ExitCode exitCode = this._shutdownExitCode.get();
            if (exitCode != null) {
                ShutdownService.this.shutdownImpl(exitCode);
            }
        }
    }
}

