/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread;

import com.caucho.config.ConfigException;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownService;
import com.caucho.env.thread.ResinThread;
import com.caucho.env.thread.ThreadTask;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.ThreadDump;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadPool {
    private static final L10N L = new L10N(ThreadPool.class);
    private static final Logger log = Logger.getLogger(ThreadPool.class.getName());
    private static final long MAX_EXPIRE = 0x3FFFFFFFFFFFFFFFL;
    private static final int DEFAULT_THREAD_MAX = 8192;
    private static final int DEFAULT_IDLE_MIN = 4;
    private static final int DEFAULT_PRIORITY_IDLE_MIN = 4;
    private static final long DEFAULT_IDLE_TIMEOUT = 120000L;
    private static final int DEFAULT_EXECUTOR_TASK_MAX = 16;
    private static final long PRIORITY_TIMEOUT = 10L;
    private static final NullRunnable NULL_RUNNABLE = new NullRunnable();
    private static final AtomicReference<ThreadPool> _globalThreadPool = new AtomicReference();
    private final String _name;
    private final AtomicInteger _gId = new AtomicInteger();
    private int _threadMax = 8192;
    private int _idleMin = 4;
    private long _idleTimeout = 120000L;
    private int _priorityIdleMin = 4;
    private int _executorTaskMax = 16;
    private final ThreadLauncher _launcher;
    private final Lifecycle _lifecycle = new Lifecycle();
    private final AtomicLong _resetCount = new AtomicLong();
    private final AtomicInteger _activeCount = new AtomicInteger();
    private final AtomicInteger _startingCount = new AtomicInteger();
    private final AtomicLong _createCount = new AtomicLong();
    private final AtomicLong _overflowCount = new AtomicLong();
    private final AtomicLong _threadIdleExpireTime = new AtomicLong();
    private final AtomicReference<ThreadNode> _idleHead = new AtomicReference();
    private final AtomicInteger _idleCount = new AtomicInteger();
    private final AtomicReference<ThreadNode> _priorityIdleHead = new AtomicReference();
    private final AtomicInteger _priorityIdleCount = new AtomicInteger();
    private final ConcurrentLinkedQueue<ThreadTask> _taskQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ThreadTask> _priorityQueue = new ConcurrentLinkedQueue();
    private int _waitCount;
    private final Object _executorLock = new Object();
    private int _executorTaskCount;
    private ExecutorQueueItem _executorQueueHead;
    private ExecutorQueueItem _executorQueueTail;

    public ThreadPool() {
        this("system");
    }

    public ThreadPool(String name) {
        this._name = name;
        this._launcher = new ThreadLauncher();
        this.init();
    }

    public static ThreadPool getCurrent() {
        return ThreadPool.getThreadPool();
    }

    public static ThreadPool getThreadPool() {
        ThreadPool pool = _globalThreadPool.get();
        if (pool == null) {
            pool = new ThreadPool();
            if (_globalThreadPool.compareAndSet(null, pool)) {
                pool.start();
            } else {
                pool = _globalThreadPool.get();
            }
        }
        return pool;
    }

    public void setThreadMax(int max) {
        if (max < this._idleMin) {
            throw new ConfigException(L.l("<thread-idle-min> ({0}) must be less than <thread-max> ({1})", this._idleMin, max));
        }
        if (max < 1) {
            throw new ConfigException(L.l("<thread-max> ({0}) must be greater than zero", max));
        }
        this._threadMax = max;
        this.init();
    }

    public int getThreadMax() {
        return this._threadMax;
    }

    public void setIdleMin(int min) {
        if (this._threadMax < min) {
            throw new ConfigException(L.l("<thread-idle-min> ({0}) must be less than <thread-max> ({1})", min, this._threadMax));
        }
        if (min <= 0) {
            throw new ConfigException(L.l("<thread-idle-min> ({0}) must be greater than 0.", min));
        }
        this._idleMin = min;
        this.init();
    }

    public int getIdleMin() {
        return this._idleMin;
    }

    public void setIdleTimeout(long timeout) {
        this._idleTimeout = timeout;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setPriorityIdleMin(int priority) {
        this._priorityIdleMin = priority;
        this.init();
    }

    public int getPriorityIdleMin() {
        return this._priorityIdleMin;
    }

    public void setExecutorTaskMax(int max) {
        if (this._threadMax < max) {
            throw new ConfigException(L.l("<thread-executor-max> ({0}) must be less than <thread-max> ({1})", max, this._threadMax));
        }
        if (max == 0) {
            throw new ConfigException(L.l("<thread-executor-max> must not be zero."));
        }
        this._executorTaskMax = max;
    }

    public int getExecutorTaskMax() {
        return this._executorTaskMax;
    }

    public int getThreadCount() {
        return this._activeCount.get();
    }

    public int getThreadActiveCount() {
        return this._activeCount.get() - this._idleCount.get() - this._priorityIdleCount.get();
    }

    public int getThreadStartingCount() {
        return this._startingCount.get();
    }

    public int getThreadIdleCount() {
        return this._idleCount.get();
    }

    public int getPriorityIdleCount() {
        return this._priorityIdleCount.get();
    }

    public int getThreadWaitCount() {
        return this._waitCount;
    }

    public int getFreeThreadCount() {
        return this._threadMax - this._activeCount.get() - this._startingCount.get();
    }

    public long getThreadCreateCountTotal() {
        return this._createCount.get();
    }

    public long getThreadOverflowCountTotal() {
        return this._overflowCount.get();
    }

    public int getThreadPriorityQueueSize() {
        return this._priorityQueue.size();
    }

    public int getThreadTaskQueueSize() {
        return this._taskQueue.size();
    }

    private void init() {
        long now = Alarm.getCurrentTime();
        this._threadIdleExpireTime.set(now + this._idleTimeout);
    }

    public void start() {
        if (this._lifecycle.toActive()) {
            this._launcher.start();
        }
    }

    public boolean schedule(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = true;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue);
    }

    public boolean schedule(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTimeActual() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = true;
        return this.scheduleImpl(task, loader, expire, isPriority, isQueue);
    }

    public void schedulePriority(Runnable task) {
        boolean isQueue;
        boolean isPriority;
        long expire;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!this.scheduleImpl(task, loader, expire = Alarm.getCurrentTimeActual() + 10L, isPriority = true, isQueue = true)) {
            log.warning(this + " unable to schedule priority thread " + task + " pri=" + this._priorityIdleMin + " active=" + this._activeCount.get() + " idle=" + (this._idleCount.get() + this._startingCount.get()) + " max=" + this._threadMax);
            OverflowThread item = new OverflowThread(task);
            item.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleExecutorTask(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Object object = this._executorLock;
        synchronized (object) {
            ++this._executorTaskCount;
            if (this._executorTaskCount <= this._executorTaskMax || this._executorTaskMax < 0) {
                boolean isPriority = false;
                boolean isQueue = true;
                return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue);
            }
            ExecutorQueueItem item = new ExecutorQueueItem(task, loader);
            if (this._executorQueueTail != null) {
                this._executorQueueTail._next = item;
            } else {
                this._executorQueueHead = item;
            }
            this._executorQueueTail = item;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeExecutorTask() {
        ExecutorQueueItem item = null;
        Object object = this._executorLock;
        synchronized (object) {
            --this._executorTaskCount;
            assert (this._executorTaskCount >= 0);
            if (this._executorQueueHead != null) {
                item = this._executorQueueHead;
                this._executorQueueHead = item._next;
                if (this._executorQueueHead == null) {
                    this._executorQueueTail = null;
                }
            }
        }
        if (item != null) {
            Runnable task = item.getRunnable();
            ClassLoader loader = item.getLoader();
            boolean isPriority = false;
            boolean isQueue = true;
            this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue);
        }
    }

    public boolean start(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = false;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue);
    }

    public boolean start(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTimeActual() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = false;
        return this.scheduleImpl(task, loader, expire, isPriority, isQueue);
    }

    public void startPriority(Runnable task) {
        boolean isQueue;
        boolean isPriority;
        long expire;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!this.scheduleImpl(task, loader, expire = Alarm.getCurrentTimeActual() + 10L, isPriority = true, isQueue = true)) {
            log.warning(this + " unable to start priority thread " + task + " pri=" + this._priorityIdleMin + " active=" + this._activeCount.get() + " idle=" + this._idleCount.get() + " starting=" + this._startingCount.get() + " max=" + this._threadMax);
            ThreadDump.dumpThreads();
            OverflowThread item = new OverflowThread(task);
            item.start();
        }
    }

    public boolean startPriority(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTimeActual() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = true;
        boolean isQueue = false;
        return this.scheduleImpl(task, loader, expire, isPriority, isQueue);
    }

    private boolean scheduleImpl(Runnable task, ClassLoader loader, long expireTime, boolean isPriority, boolean isQueueIfFull) {
        if (this.scheduleIdle(task, loader, isPriority)) {
            return true;
        }
        this._launcher.wake();
        if (!isQueueIfFull && this.isThreadMax()) {
            return false;
        }
        Thread requestThread = null;
        if (!isQueueIfFull) {
            requestThread = Thread.currentThread();
        }
        ThreadTask taskItem = new ThreadTask(task, loader, requestThread);
        if (isPriority) {
            this._priorityQueue.offer(taskItem);
        } else {
            this._taskQueue.offer(taskItem);
        }
        ResinThread thread = this.popIdleThread();
        if (thread != null) {
            thread.scheduleTask(NULL_RUNNABLE, null);
        } else if (isPriority && (thread = this.popPriorityThread()) != null) {
            thread.scheduleTask(NULL_RUNNABLE, null);
        }
        if (!isQueueIfFull) {
            taskItem.park(expireTime);
        }
        return true;
    }

    private boolean isThreadMax() {
        return this._threadMax <= this._activeCount.get() && this._startingCount.get() == 0;
    }

    private boolean scheduleIdle(Runnable task, ClassLoader loader, boolean isPriority) {
        ResinThread thread;
        if (!this._priorityQueue.isEmpty()) {
            return false;
        }
        if ((this._taskQueue.isEmpty() || isPriority) && (thread = this.popIdleThread()) != null) {
            thread.scheduleTask(task, loader);
            return true;
        }
        if (!isPriority) {
            return false;
        }
        ResinThread priorityThread = this.popPriorityThread();
        if (priorityThread != null) {
            priorityThread.scheduleTask(task, loader);
            return true;
        }
        return false;
    }

    void startIdleThread() {
        this._launcher.wake();
    }

    ThreadTask nextTask(ResinThread thread) {
        int idleCount;
        ThreadTask item = this._priorityQueue.poll();
        if (item != null) {
            return item;
        }
        int priorityIdleCount = this._priorityIdleCount.get();
        if (this._priorityIdleMin <= priorityIdleCount + (idleCount = this._idleCount.get()) && (item = this._taskQueue.poll()) != null) {
            return item;
        }
        return null;
    }

    boolean isIdleExpire() {
        if (!this._lifecycle.isActive()) {
            return true;
        }
        long now = Alarm.getCurrentTimeActual();
        long idleExpire = this._threadIdleExpireTime.get();
        if (this._idleMin < this._idleCount.get() && idleExpire < now) {
            long nextIdleExpire = now + this._idleTimeout;
            return this._threadIdleExpireTime.compareAndSet(idleExpire, nextIdleExpire);
        }
        return false;
    }

    void pushIdleThread(ResinThread thread) {
        int priorityIdle = this._priorityIdleCount.get();
        if (priorityIdle < this._priorityIdleMin && this._priorityIdleCount.compareAndSet(priorityIdle, priorityIdle + 1)) {
            this.pushIdleThread(this._priorityIdleHead, thread);
        } else {
            this._idleCount.incrementAndGet();
            this.pushIdleThread(this._idleHead, thread);
        }
    }

    private void pushIdleThread(AtomicReference<ThreadNode> idleHeadRef, ResinThread thread) {
        ThreadNode next;
        ThreadNode head = new ThreadNode(thread);
        do {
            next = idleHeadRef.get();
            head.setNext(next);
        } while (!idleHeadRef.compareAndSet(next, head));
    }

    private ResinThread popPriorityThread() {
        ResinThread thread = this.popIdleThread(this._priorityIdleHead);
        if (thread != null) {
            this._priorityIdleCount.decrementAndGet();
        }
        return thread;
    }

    private ResinThread popIdleThread() {
        int idleCount;
        ResinThread thread = this.popIdleThread(this._idleHead);
        if (thread != null && this._idleMin <= (idleCount = this._idleCount.decrementAndGet())) {
            return thread;
        }
        long now = Alarm.getCurrentTimeActual();
        this._threadIdleExpireTime.set(now + this._idleTimeout);
        this._launcher.wake();
        return thread;
    }

    private ResinThread popIdleThread(AtomicReference<ThreadNode> idleHeadRef) {
        ThreadNode next;
        ThreadNode head;
        do {
            if ((head = idleHeadRef.get()) != null) continue;
            return null;
        } while (!idleHeadRef.compareAndSet(head, next = head.getNext()));
        return head.getThread();
    }

    public void reset() {
        this._resetCount.incrementAndGet();
    }

    public void closeEnvironment(ClassLoader env) {
        this.reset();
    }

    public void interrupt() {
        ResinThread thread;
        while ((thread = this.popIdleThread()) != null) {
            thread.close();
        }
    }

    long onThreadStart() {
        this._activeCount.incrementAndGet();
        int startCount = this._startingCount.decrementAndGet();
        if (startCount < 0) {
            this._startingCount.set(0);
            new IllegalStateException().printStackTrace();
        }
        this._createCount.incrementAndGet();
        return this._resetCount.get();
    }

    void onThreadFirstTask() {
        this._launcher.wake();
    }

    void onThreadEnd() {
        this._activeCount.decrementAndGet();
        this._launcher.wake();
    }

    private boolean doStart() {
        int idleCount = this._idleCount.get();
        int priorityIdleCount = this._priorityIdleCount.get();
        int startingCount = this._startingCount.getAndIncrement();
        int threadCount = this._activeCount.get() + startingCount;
        if (this._threadMax < threadCount) {
            this._startingCount.decrementAndGet();
            return false;
        }
        if (idleCount + startingCount < this._idleMin || priorityIdleCount + startingCount < this._priorityIdleMin) {
            return true;
        }
        this._startingCount.decrementAndGet();
        return false;
    }

    public void close() {
        if (this == _globalThreadPool.get()) {
            throw new IllegalStateException(L.l("Cannot close global thread pool"));
        }
        this._lifecycle.toDestroy();
        this.interrupt();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }

    static final class ThreadNode {
        private final ResinThread _thread;
        private ThreadNode _next;

        ThreadNode(ResinThread thread) {
            this._thread = thread;
        }

        ResinThread getThread() {
            return this._thread;
        }

        void setNext(ThreadNode next) {
            this._next = next;
        }

        ThreadNode getNext() {
            return this._next;
        }
    }

    static class NullRunnable
    implements Runnable {
        NullRunnable() {
        }

        public void run() {
        }
    }

    static class ExecutorQueueItem {
        Runnable _runnable;
        ClassLoader _loader;
        ExecutorQueueItem _next;

        ExecutorQueueItem(Runnable runnable, ClassLoader loader) {
            this._runnable = runnable;
            this._loader = loader;
        }

        Runnable getRunnable() {
            return this._runnable;
        }

        ClassLoader getLoader() {
            return this._loader;
        }
    }

    final class ThreadLauncher
    extends Thread {
        private final AtomicBoolean _isWake;

        private ThreadLauncher() {
            super("resin-thread-launcher");
            this._isWake = new AtomicBoolean();
            this.setDaemon(true);
        }

        void wake() {
            if (!this._isWake.getAndSet(true)) {
                LockSupport.unpark(this);
            }
        }

        private boolean startConnection(boolean isWait) throws InterruptedException {
            if (ThreadPool.this.doStart()) {
                try {
                    long now = Alarm.getCurrentTimeActual();
                    ThreadPool.this._threadIdleExpireTime.set(now + ThreadPool.this._idleTimeout);
                    int id = ThreadPool.this._gId.incrementAndGet();
                    ResinThread poolThread = new ResinThread(ThreadPool.this, id);
                    poolThread.start();
                    return true;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    String msg = "Resin exiting because of failed thread";
                    ShutdownService.shutdownActive(ExitCode.THREAD, msg);
                }
            } else {
                Thread.interrupted();
                if (isWait && !this._isWake.getAndSet(false)) {
                    LockSupport.park();
                }
            }
            return false;
        }

        public void run() {
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            Thread.currentThread().setContextClassLoader(systemLoader);
            try {
                while (this.startConnection(false)) {
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            while (ThreadPool.this._lifecycle.isActive()) {
                try {
                    this.startConnection(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    String msg = "ThreadPool start connection failed";
                    ShutdownService.shutdownActive(ExitCode.THREAD, msg);
                }
            }
        }
    }

    final class OverflowThread
    extends Thread {
        private Runnable _task;
        private ClassLoader _loader;

        OverflowThread(Runnable task) {
            super("resin-overflow-" + task.getClass().getSimpleName());
            this.setDaemon(true);
            this._task = task;
            this._loader = Thread.currentThread().getContextClassLoader();
        }

        public void run() {
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(this._loader);
            try {
                ThreadPool.this._overflowCount.incrementAndGet();
                this._task.run();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

