/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.warning;

import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.warning.WarningHandler;
import com.caucho.util.L10N;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class WarningService
extends AbstractResinService {
    private static final L10N L = new L10N(WarningService.class);
    public static final int START_PRIORITY = 1;
    private static final Logger log = Logger.getLogger(WarningService.class.getName());
    private final CopyOnWriteArrayList<WarningHandler> _handlerList = new CopyOnWriteArrayList();

    public static WarningService getCurrent() {
        return ResinSystem.getCurrentService(WarningService.class);
    }

    public static WarningService create() {
        return WarningService.create(ResinSystem.getCurrent());
    }

    public static WarningService create(ResinSystem resinSystem) {
        if (resinSystem == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1}", (Object)WarningService.class.getSimpleName(), ResinSystem.class.getSimpleName()));
        }
        WarningService service = resinSystem.getService(WarningService.class);
        if (service == null) {
            service = new WarningService();
            resinSystem.addServiceIfAbsent(service);
            service = resinSystem.getService(WarningService.class);
        }
        return service;
    }

    public void warning(String msg) {
        log.warning("WarningService: " + msg);
        System.err.println("WarningService: " + msg);
        for (WarningHandler handler : this._handlerList) {
            handler.warning(msg);
        }
    }

    public static void sendCurrentWarning(String msg) {
        WarningService warning = WarningService.getCurrent();
        if (warning != null) {
            warning.warning(msg);
        }
    }

    public void addHandler(WarningHandler handler) {
        this._handlerList.add(handler);
    }

    public int getStartPriority() {
        return 1;
    }
}

