/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.bam.Actor;
import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.bam.Broker;
import com.caucho.bam.BrokerListener;
import com.caucho.config.inject.InjectManager;
import com.caucho.hemp.broker.DomainManager;
import com.caucho.hemp.broker.HempBrokerManager;
import com.caucho.hemp.broker.HempMemoryQueue;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.remote.BamService;
import com.caucho.server.admin.AdminService;
import com.caucho.util.Alarm;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;

public class HempBroker
implements Broker,
ActorStream,
Extension {
    private static final Logger log = Logger.getLogger(HempBroker.class.getName());
    private static final L10N L = new L10N(HempBroker.class);
    private static final EnvironmentLocal<HempBroker> _localBroker = new EnvironmentLocal();
    private final AtomicLong _jidGenerator = new AtomicLong(Alarm.getCurrentTime());
    private HempBrokerManager _manager;
    private DomainManager _domainManager;
    private final ConcurrentHashMap<String, WeakReference<ActorStream>> _actorStreamMap = new ConcurrentHashMap();
    private final HashMap<String, ActorStream> _actorMap = new HashMap();
    private final Map<String, WeakReference<ActorStream>> _actorCache = Collections.synchronizedMap(new HashMap());
    private String _domain = "localhost";
    private String _managerJid = "localhost";
    private ArrayList<String> _aliasList = new ArrayList();
    private BrokerListener[] _actorManagerList = new BrokerListener[0];
    private volatile boolean _isClosed;

    public HempBroker(HempBrokerManager manager) {
        this._manager = manager;
        Environment.addCloseListener(this);
        if (_localBroker.getLevel() == null) {
            _localBroker.set(this);
        }
    }

    public HempBroker(HempBrokerManager manager, String domain) {
        this(manager);
        this._domain = domain;
        this._managerJid = domain;
    }

    public static HempBroker getCurrent() {
        return _localBroker.get();
    }

    public void setDomainManager(DomainManager domainManager) {
        this._domainManager = domainManager;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void addAlias(String domain) {
        this._aliasList.add(domain);
    }

    public ActorStream getBrokerStream() {
        return this;
    }

    public void addBrokerListener(BrokerListener actorManager) {
        BrokerListener[] actorManagerList = new BrokerListener[this._actorManagerList.length + 1];
        System.arraycopy(this._actorManagerList, 0, actorManagerList, 0, this._actorManagerList.length);
        actorManagerList[actorManagerList.length - 1] = actorManager;
        this._actorManagerList = actorManagerList;
    }

    public String createClient(ActorStream clientStream, String uid, String resourceId) {
        String jid = this.generateJid(uid, resourceId);
        this._actorStreamMap.put(jid, new WeakReference<ActorStream>(clientStream));
        if (log.isLoggable(Level.FINE)) {
            log.fine(clientStream + " " + jid + " created");
        }
        return jid;
    }

    protected String generateJid(String uid, String resource) {
        StringBuilder sb = new StringBuilder();
        if (uid == null) {
            uid = "anonymous";
        }
        if (uid.indexOf(64) > 0) {
            sb.append(uid);
        } else {
            sb.append(uid).append('@').append(this.getDomain());
        }
        sb.append("/");
        if (resource != null) {
            sb.append(resource);
        } else {
            Base64.encode(sb, this._jidGenerator.incrementAndGet());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActor(ActorStream actor) {
        String jid = actor.getJid();
        AbstractMap abstractMap = this._actorMap;
        synchronized (abstractMap) {
            ActorStream oldActor = this._actorMap.get(jid);
            if (oldActor != null) {
                throw new IllegalStateException(L.l("duplicated jid='{0}' is not allowed", jid));
            }
            this._actorMap.put(jid, actor);
        }
        abstractMap = this._actorStreamMap;
        synchronized (abstractMap) {
            WeakReference<ActorStream> oldRef = this._actorStreamMap.get(jid);
            if (oldRef != null && oldRef.get() != null) {
                throw new IllegalStateException(L.l("duplicated jid='{0}' is not allowed", jid));
            }
            this._actorStreamMap.put(jid, new WeakReference<ActorStream>(actor));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " addActor jid=" + jid + " " + actor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActor(ActorStream actor) {
        String jid = actor.getJid();
        AbstractMap abstractMap = this._actorMap;
        synchronized (abstractMap) {
            this._actorMap.remove(jid);
        }
        abstractMap = this._actorStreamMap;
        synchronized (abstractMap) {
            this._actorStreamMap.remove(jid);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " removeActor jid=" + jid + " " + actor);
        }
    }

    protected String getManagerJid() {
        return this._managerJid;
    }

    protected String getDomain() {
        return this._domain;
    }

    public String getJid() {
        return this._domain;
    }

    public void message(String to, String from, Serializable value) {
        ActorStream stream = this.findActorStream(to);
        if (stream != null) {
            stream.message(to, from, value);
        } else {
            log.fine(this + " sendMessage to=" + to + " from=" + from + " is an unknown actor stream.");
        }
    }

    public void messageError(String to, String from, Serializable value, ActorError error) {
        ActorStream stream = this.findActorStream(to);
        if (stream != null) {
            stream.messageError(to, from, value, error);
        } else {
            log.fine(this + " sendMessageError to=" + to + " from=" + from + " error=" + error + " is an unknown actor stream.");
        }
    }

    public void queryGet(long id, String to, String from, Serializable payload) {
        ActorStream stream = this.findActorStream(to);
        if (stream != null) {
            try {
                stream.queryGet(id, to, from, payload);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
                ActorError error = ActorError.create(e);
                this.queryError(id, from, to, payload, error);
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " queryGet to unknown stream to='" + to + "' from=" + from);
        }
        String msg = L.l("'{0}' is an unknown actor for queryGet", to);
        ActorError error = new ActorError("cancel", "service-unavailable", msg);
        this.queryError(id, from, to, payload, error);
    }

    public void querySet(long id, String to, String from, Serializable payload) {
        ActorStream stream = this.findActorStream(to);
        if (stream != null) {
            try {
                stream.querySet(id, to, from, payload);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
                ActorError error = ActorError.create(e);
                this.queryError(id, from, to, payload, error);
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " querySet to unknown stream '" + to + "' from=" + from);
        }
        String msg = L.l("'{0}' is an unknown actor for querySet", to);
        ActorError error = new ActorError("cancel", "service-unavailable", msg);
    }

    public void queryResult(long id, String to, String from, Serializable value) {
        ActorStream stream = this.findActorStream(to);
        if (stream == null) {
            throw new RuntimeException(L.l("{0}: {1} is an unknown actor stream.", (Object)this, to));
        }
        stream.queryResult(id, to, from, value);
    }

    public void queryError(long id, String to, String from, Serializable payload, ActorError error) {
        ActorStream stream = this.findActorStream(to);
        if (stream == null) {
            throw new RuntimeException(L.l("{0} is an unknown actor stream.", to));
        }
        stream.queryError(id, to, from, payload, error);
    }

    protected ActorStream findActorStream(String jid) {
        Actor actor;
        ActorStream stream;
        if (jid == null) {
            return null;
        }
        WeakReference<ActorStream> ref = this._actorStreamMap.get(jid);
        if (ref != null && (stream = (ActorStream)ref.get()) != null) {
            return stream;
        }
        if (jid.endsWith("@")) {
            jid = jid + this.getDomain();
        }
        if ((actor = this.findParentActor(jid)) == null) {
            return this.putActorStream(jid, this.findDomain(jid));
        }
        if (jid.equals(actor.getJid())) {
            ActorStream actorStream = actor.getActorStream();
            if (actorStream != null) {
                return this.putActorStream(jid, actorStream);
            }
        } else {
            ref = this._actorStreamMap.get(jid);
            if (ref != null) {
                return (ActorStream)ref.get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActorStream putActorStream(String jid, ActorStream actorStream) {
        if (actorStream == null) {
            return null;
        }
        ConcurrentHashMap<String, WeakReference<ActorStream>> concurrentHashMap = this._actorStreamMap;
        synchronized (concurrentHashMap) {
            WeakReference<ActorStream> ref = this._actorStreamMap.get(jid);
            if (ref != null) {
                return (ActorStream)ref.get();
            }
            this._actorStreamMap.put(jid, new WeakReference<ActorStream>(actorStream));
            return actorStream;
        }
    }

    protected Actor findParentActor(String jid) {
        return null;
    }

    protected ActorStream findDomain(String domain) {
        if (domain == null) {
            return null;
        }
        if ("local".equals(domain)) {
            return this.getBrokerStream();
        }
        Broker broker = null;
        if (this._manager != null) {
            broker = this._manager.findBroker(domain);
        }
        if (broker == this) {
            return null;
        }
        ActorStream stream = null;
        if (this._domainManager != null) {
            stream = this._domainManager.findDomain(domain);
        }
        return stream;
    }

    protected boolean startActorFromManager(String jid) {
        for (BrokerListener manager : this._actorManagerList) {
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeActor(String jid) {
        int p = jid.indexOf(47);
        if (p > 0) {
            String owner = jid.substring(0, p);
            Actor actor = this.findParentActor(owner);
        }
        this._actorCache.remove(jid);
        ConcurrentHashMap<String, WeakReference<ActorStream>> concurrentHashMap = this._actorStreamMap;
        synchronized (concurrentHashMap) {
            this._actorStreamMap.remove(jid);
        }
    }

    public void addStartupActor(Bean bean, String name, int threadMax) {
        ActorStartup startup = new ActorStartup(bean, name, threadMax);
        Environment.addEnvironmentListener(startup);
    }

    private void startActor(Bean bean, String name, int threadMax) {
        InjectManager beanManager = InjectManager.getCurrent();
        Actor actor = (Actor)beanManager.getReference(bean);
        actor.setLinkStream(this);
        String jid = name;
        if (jid == null || "".equals(jid)) {
            jid = bean.getName();
        }
        if (jid == null || "".equals(jid)) {
            jid = bean.getBeanClass().getSimpleName();
        }
        if (jid.indexOf(64) < 0) {
            jid = jid + '@' + this.getJid();
        } else if (jid.endsWith("@")) {
            jid = jid.substring(0, jid.length() - 1);
        }
        actor.setJid(jid);
        Actor bamActor = actor;
        if (threadMax > 0) {
            ActorStream actorStream = bamActor.getActorStream();
            actorStream = new HempMemoryQueue(actorStream, this, threadMax);
            bamActor.setActorStream(actorStream);
        }
        this.addActor(bamActor.getActorStream());
        Environment.addCloseListener(new ActorClose(bamActor));
    }

    private void startActor(Bean bean, AdminService bamService) {
        InjectManager beanManager = InjectManager.getCurrent();
        Actor actor = (Actor)beanManager.getReference(bean);
        actor.setLinkStream(this);
        String jid = bamService.name();
        if (jid == null || "".equals(jid)) {
            jid = bean.getName();
        }
        if (jid == null || "".equals(jid)) {
            jid = bean.getBeanClass().getSimpleName();
        }
        actor.setJid(jid);
        int threadMax = bamService.threadMax();
        Actor bamActor = actor;
        if (threadMax > 0) {
            ActorStream actorStream = bamActor.getActorStream();
            actorStream = new HempMemoryQueue(actorStream, this, threadMax);
            bamActor.setActorStream(actorStream);
        }
        this.addActor(bamActor.getActorStream());
        Environment.addCloseListener(new ActorClose(bamActor));
    }

    public void close() {
        this._isClosed = true;
        this._manager.removeBroker(this._domain);
        for (String alias : this._aliasList) {
            this._manager.removeBroker(alias);
        }
        this._actorMap.clear();
        this._actorCache.clear();
        this._actorStreamMap.clear();
    }

    private String getJid(Actor actor, Annotation[] annList) {
        String jid;
        BamService bamAnn = this.findActor(annList);
        String name = "";
        if (bamAnn != null) {
            name = bamAnn.name();
        }
        if (name == null || "".equals(name)) {
            name = actor.getJid();
        }
        if (name == null || "".equals(name)) {
            name = actor.getClass().getSimpleName();
        }
        if ((jid = name).indexOf(64) < 0 && jid.indexOf(47) < 0) {
            jid = name + "@" + this.getJid();
        }
        return jid;
    }

    private int getThreadMax(Annotation[] annList) {
        BamService bamAnn = this.findActor(annList);
        if (bamAnn != null) {
            return bamAnn.threadMax();
        }
        return 1;
    }

    private BamService findActor(Annotation[] annList) {
        for (Annotation ann : annList) {
            if (!ann.annotationType().equals(BamService.class)) continue;
            return (BamService)ann;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._domain + "]";
    }

    public class ActorClose {
        private Actor _actor;

        ActorClose(Actor actor) {
            this._actor = actor;
        }

        public void close() {
            HempBroker.this.removeActor(this._actor.getActorStream());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ActorStartup
    implements EnvironmentListener {
        private Bean<?> _bean;
        private String _name;
        private int _threadMax;

        ActorStartup(Bean<?> bean, String name, int threadMax) {
            this._bean = bean;
            this._name = name;
            this._threadMax = threadMax;
        }

        Bean<?> getBean() {
            return this._bean;
        }

        String getName() {
            return this._name;
        }

        int getThreadMax() {
            return this._threadMax;
        }

        @Override
        public void environmentConfigure(EnvironmentClassLoader loader) {
        }

        @Override
        public void environmentBind(EnvironmentClassLoader loader) {
        }

        @Override
        public void environmentStart(EnvironmentClassLoader loader) {
            HempBroker.this.startActor(this._bean, this._name, this._threadMax);
        }

        @Override
        public void environmentStop(EnvironmentClassLoader loader) {
        }
    }
}

