/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.bam.Broker;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.cluster.Server;
import com.caucho.server.host.Host;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HempBrokerManager {
    private static final Logger log = Logger.getLogger(HempBrokerManager.class.getName());
    private static EnvironmentLocal<HempBrokerManager> _localBroker = new EnvironmentLocal();
    private final HashMap<String, WeakReference<Broker>> _brokerMap = new HashMap();

    public HempBrokerManager() {
        _localBroker.set(this);
    }

    public static HempBrokerManager getCurrent() {
        return _localBroker.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBroker(String name, Broker broker) {
        HashMap<String, WeakReference<Broker>> hashMap = this._brokerMap;
        synchronized (hashMap) {
            this._brokerMap.put(name, new WeakReference<Broker>(broker));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " add " + broker + " as '" + name + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Broker removeBroker(String name) {
        WeakReference<Broker> brokerRef = null;
        HashMap<String, WeakReference<Broker>> hashMap = this._brokerMap;
        synchronized (hashMap) {
            brokerRef = this._brokerMap.remove(name);
        }
        if (brokerRef != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " remove " + name);
            }
            return (Broker)brokerRef.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Broker findBroker(String name) {
        if (name == null) {
            return null;
        }
        int p = name.indexOf(64);
        int q = name.indexOf(47);
        if (p >= 0 && q >= 0) {
            name = name.substring(p + 1, q);
        } else if (p >= 0) {
            name = name.substring(p + 1);
        } else if (q >= 0) {
            name = name.substring(0, q);
        }
        WeakReference<Broker> brokerRef = null;
        HashMap<String, WeakReference<Broker>> hashMap = this._brokerMap;
        synchronized (hashMap) {
            brokerRef = this._brokerMap.get(name);
        }
        if (brokerRef != null) {
            return (Broker)brokerRef.get();
        }
        Server server = Server.getCurrent();
        if (server == null || !server.isActive()) {
            return null;
        }
        Host host = server.getHost(name, 5222);
        if (host == null) {
            return null;
        }
        if ("default".equals(host.getHostName()) && !"localhost".equals(name)) {
            return null;
        }
        Broker broker = host.getBamBroker();
        HashMap<String, WeakReference<Broker>> hashMap2 = this._brokerMap;
        synchronized (hashMap2) {
            this._brokerMap.put(name, new WeakReference<Broker>(broker));
        }
        return broker;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

