/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.packet;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.util.Alarm;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;

public class Packet {
    private static final Logger log = Logger.getLogger(Packet.class.getName());
    private final String _to;
    private final String _from;
    private final long _createTime;
    private Thread _waitThread;
    private volatile boolean _isDequeue;

    public Packet() {
        this._createTime = 0L;
        this._to = null;
        this._from = null;
    }

    public Packet(String to, String from) {
        this._createTime = Alarm.getCurrentTime();
        this._to = to;
        this._from = from;
    }

    public final String getTo() {
        return this._to;
    }

    public final String getFrom() {
        return this._from;
    }

    public void dispatch(ActorStream handler, ActorStream toSource) {
    }

    public void dispatchError(ActorStream handler, ActorStream toSource, ActorError error) {
        log.fine(this + " dispatchError " + error);
    }

    public void waitForDequeue(long timeout) {
        this._waitThread = Thread.currentThread();
        if (!this._isDequeue) {
            LockSupport.parkUntil(Alarm.getCurrentTimeActual() + timeout);
        }
        this._waitThread = null;
    }

    public void unparkDequeue() {
        this._isDequeue = true;
        Thread thread = this._waitThread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[to=");
        sb.append(this._to);
        if (this._from != null) {
            sb.append(",from=");
            sb.append(this._from);
        }
        sb.append("]");
        return sb.toString();
    }
}

