/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.packet;

import com.caucho.hemp.packet.Packet;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PacketQueue {
    private static final L10N L = new L10N(PacketQueue.class);
    private static final Logger log = Logger.getLogger(PacketQueue.class.getName());
    private final String _name;
    private final int _discardMaxSize;
    private final int _blockMaxSize;
    private final long _expireTimeout;
    private final AtomicReference<QueueItem> _head = new AtomicReference();
    private final AtomicReference<QueueItem> _tail = new AtomicReference();
    private final AtomicInteger _size = new AtomicInteger();
    private final AtomicInteger _blockCount = new AtomicInteger();
    private final Object _blockLock = new Object();

    public PacketQueue(String name, int discardMaxSize, int blockMaxSize, long expireTimeout) {
        this._name = name;
        if (discardMaxSize > 0x3FFFFFFF || discardMaxSize < 0) {
            discardMaxSize = 0x3FFFFFFF;
        }
        if (discardMaxSize == 0) {
            throw new IllegalArgumentException(L.l("discardMaxSize may not be zero"));
        }
        this._discardMaxSize = discardMaxSize;
        if (blockMaxSize > 0x3FFFFFFF || blockMaxSize < 0) {
            blockMaxSize = 0x3FFFFFFF;
        }
        if (blockMaxSize == 0) {
            throw new IllegalArgumentException(L.l("blockMaxSize may not be zero"));
        }
        this._blockMaxSize = blockMaxSize;
        if (expireTimeout > 0x3FFFFFFFFFFFFFFFL || expireTimeout < 0L) {
            expireTimeout = 0x3FFFFFFFFFFFFFFFL;
        }
        if (expireTimeout == 0L) {
            throw new IllegalArgumentException(L.l("expireTimeout may not be zero"));
        }
        this._expireTimeout = expireTimeout;
        this._head.set(new QueueItem(null));
        this._tail.set(this._head.get());
    }

    public final int getSize() {
        return this._size.get();
    }

    public final boolean isEmpty() {
        QueueItem tail = this._tail.get();
        return tail.getPacket() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void enqueue(Packet packet) {
        QueueItem tail;
        block13: {
            while (this._discardMaxSize < this._size.get()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " dropping overflow packets size=" + this._size.get() + " maxSize=" + this._discardMaxSize);
                }
                this.dequeue();
            }
            if (this._blockMaxSize < this._size.get()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " blocking due to overflow packets size=" + this._size.get() + " maxSize=" + this._blockMaxSize);
                }
                this._blockCount.incrementAndGet();
                try {
                    Object var5_4;
                    try {
                        Object object = this._blockLock;
                        synchronized (object) {
                            if (this._blockMaxSize < this._size.get()) {
                                this._blockLock.wait(1000L);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.ALL, e.toString(), e);
                        var5_4 = null;
                        this._blockCount.decrementAndGet();
                        break block13;
                    }
                    var5_4 = null;
                    this._blockCount.decrementAndGet();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this._blockCount.decrementAndGet();
                    throw throwable;
                }
            }
        }
        QueueItem item = new QueueItem(packet);
        while (true) {
            tail = this._tail.get();
            QueueItem next = tail.getNext();
            if (tail != this._tail.get()) continue;
            if (next != null) {
                this._tail.compareAndSet(tail, next);
                continue;
            }
            if (tail.compareAndSetNext(next, item)) break;
        }
        this._tail.compareAndSet(tail, item);
        this._size.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Packet dequeue() {
        Packet packet;
        int spinCount = 4;
        while (true) {
            QueueItem head = this._head.get();
            QueueItem tail = this._tail.get();
            QueueItem next = head.getNext();
            if (head != this._head.get()) continue;
            if (head == tail) {
                if (next != null) {
                    this._tail.compareAndSet(tail, next);
                    continue;
                }
                if (--spinCount > 0) continue;
                return null;
            }
            if (next == null || !this._head.compareAndSet(head, next)) continue;
            this._size.decrementAndGet();
            packet = next.getPacket();
            next.clearPacket();
            if (this._blockCount.get() > 0 && this._size.get() < this._blockMaxSize) {
                Object object = this._blockLock;
                synchronized (object) {
                    this._blockLock.notifyAll();
                }
            }
            long createTime = next.getCreateTime();
            long now = Alarm.getCurrentTime();
            if (createTime > 0L && now <= createTime + this._expireTimeout) break;
        }
        return packet;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }

    static class QueueItem {
        private static final Logger log = Logger.getLogger(QueueItem.class.getName());
        private static final AtomicReferenceFieldUpdater<QueueItem, QueueItem> _casNext = AtomicReferenceFieldUpdater.newUpdater(QueueItem.class, QueueItem.class, "_next");
        private volatile QueueItem _next;
        private Packet _packet;
        private final long _createTime = Alarm.getCurrentTime();

        public QueueItem(Packet packet) {
            this._packet = packet;
        }

        public final long getCreateTime() {
            return this._createTime;
        }

        public final QueueItem getNext() {
            return this._next;
        }

        public final Packet getPacket() {
            return this._packet;
        }

        public final void clearPacket() {
            this._packet = null;
        }

        public final boolean compareAndSetNext(QueueItem expect, QueueItem update) {
            return _casNext.compareAndSet(this, expect, update);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._packet + "]";
        }
    }
}

