/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.jms.util.BytesMessageOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HessianJMSProxy
implements InvocationHandler {
    protected static Logger log = Logger.getLogger(HessianJMSProxy.class.getName());
    private HessianProxyFactory _factory;
    private MessageProducer _producer;
    private Session _jmsSession;
    private Connection _jmsConnection;
    private String _outboundName;

    HessianJMSProxy(HessianProxyFactory factory, String outboundName, String connectionFactoryName) throws NamingException, JMSException {
        this._factory = factory;
        this._outboundName = outboundName;
        Context context = (Context)new InitialContext().lookup("java:comp/env");
        ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(connectionFactoryName);
        Destination outboundDestination = (Destination)context.lookup(outboundName);
        this._jmsConnection = connectionFactory.createConnection();
        this._jmsSession = this._jmsConnection.createSession(false, 1);
        this._producer = this._jmsSession.createProducer(outboundDestination);
    }

    public String getOutboundName() {
        return this._outboundName;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object value = args[0];
            if (value == null || !Proxy.isProxyClass(value.getClass())) {
                return Boolean.FALSE;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(value);
            if (!(handler instanceof HessianJMSProxy)) {
                return new Boolean(false);
            }
            String otherOutboundName = ((HessianJMSProxy)handler).getOutboundName();
            return new Boolean(this._outboundName.equals(otherOutboundName));
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return this._outboundName.hashCode();
        }
        if (methodName.equals("getHessianType")) {
            return proxy.getClass().getInterfaces()[0].getName();
        }
        if (methodName.equals("getHessianURL")) {
            return this._outboundName;
        }
        if (methodName.equals("toString") && params.length == 0) {
            return "[HessianJMSProxy " + this._outboundName + "]";
        }
        try {
            if (this._factory.isOverloadEnabled()) {
                methodName = args != null ? methodName + "__" + args.length : methodName + "__0";
            }
            this.sendRequest(methodName, args);
            return null;
        }
        catch (Exception e) {
            throw new HessianRuntimeException(e);
        }
    }

    private void sendRequest(String methodName, Object[] args) throws JMSException, IOException {
        BytesMessage message = this._jmsSession.createBytesMessage();
        BytesMessageOutputStream os = new BytesMessageOutputStream(message);
        AbstractHessianOutput out = this._factory.getHessianOutput(os);
        out.call(methodName, args);
        out.flush();
        this._producer.send((Message)message);
    }
}

