/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.ActorException;
import com.caucho.bam.ActorStream;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.SimpleActorClient;
import com.caucho.cloud.security.SecurityService;
import com.caucho.hemp.broker.HempMemoryQueue;
import com.caucho.hmtp.AuthQuery;
import com.caucho.hmtp.AuthResult;
import com.caucho.hmtp.ClientAuthManager;
import com.caucho.hmtp.HmtpReader;
import com.caucho.hmtp.HmtpWriter;
import com.caucho.hmtp.NonceQuery;
import com.caucho.hmtp.SignedCredentials;
import com.caucho.remote.websocket.WebSocketClient;
import com.caucho.servlet.WebSocketContext;
import com.caucho.servlet.WebSocketListener;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmtpClient
extends SimpleActorClient {
    private static final L10N L = new L10N(HmtpClient.class);
    private static final Logger log = Logger.getLogger(HmtpClient.class.getName());
    private String _url;
    private String _jid;
    private WebSocketClient _webSocketClient;
    private WebSocketListener _webSocketHandler;
    private ActorException _connException;
    private ClientAuthManager _authManager = new ClientAuthManager();

    public HmtpClient(String url) {
        this._url = url;
        this._webSocketClient = new WebSocketClient(url);
        this._webSocketHandler = new HmtpWebSocketHandler();
    }

    public HmtpClient(String url, ActorStream actorStream) throws IOException {
        this(url);
        this.setClientStream(actorStream);
    }

    public void setVirtualHost(String host) {
        this._webSocketClient.setVirtualHost(host);
    }

    public void setEncryptPassword(boolean isEncrypt) {
    }

    public void connect(String user, String password) {
        this.connectImpl();
        this.loginImpl(user, (Serializable)((Object)password));
    }

    public void connect(String user, Serializable credentials) {
        this.connectImpl();
        this.loginImpl(user, credentials);
    }

    protected void connectImpl() {
        try {
            this._webSocketClient.connect(this._webSocketHandler);
        }
        catch (ActorException e) {
            this._connException = e;
            throw this._connException;
        }
        catch (IOException e) {
            this._connException = new RemoteConnectionFailedException("Failed to connect to server at " + this._url + "\n  " + e, e);
            throw this._connException;
        }
    }

    protected void loginImpl(String uid, Serializable credentials) {
        try {
            if (uid == null) {
                uid = "";
            }
            if (credentials == null) {
                credentials = "";
            }
            if (!(credentials instanceof SignedCredentials) && credentials instanceof String) {
                String password = (String)credentials;
                String clientNonce = String.valueOf(Alarm.getCurrentTime());
                NonceQuery nonceQuery = new NonceQuery(uid, clientNonce);
                NonceQuery nonceResult = (NonceQuery)this.queryGet(null, nonceQuery);
                String serverNonce = nonceResult.getNonce();
                String serverSignature = nonceResult.getSignature();
                String testSignature = this._authManager.sign(uid, clientNonce, password);
                if (!testSignature.equals(serverSignature) && "".equals(uid)) {
                    throw new ActorException(L.l("{0} server signature does not match", this));
                }
                String signature = this._authManager.sign(uid, serverNonce, password);
                SecurityService security = new SecurityService();
                credentials = "".equals(uid) ? new SignedCredentials(uid, serverNonce, signature) : security.createCredentials(uid, password, serverNonce);
            }
            AuthResult result = (AuthResult)this.querySet(null, new AuthQuery(uid, (Serializable)credentials));
            this._jid = result.getJid();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " login");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getJid() {
        return this._jid;
    }

    public String getBrokerJid() {
        String jid = this.getJid();
        if (jid == null) {
            return null;
        }
        int p = jid.indexOf(64);
        int q = jid.indexOf(47);
        if (p >= 0 && q >= 0) {
            return jid.substring(p + 1, q);
        }
        if (p >= 0) {
            return jid.substring(p + 1);
        }
        if (q >= 0) {
            return jid.substring(0, q);
        }
        return jid;
    }

    public void flush() throws IOException {
    }

    public void close() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close");
        }
        super.close();
        this._webSocketClient.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._jid + "," + this._url + "]";
    }

    protected void finalize() {
        this.close();
    }

    class HmtpWebSocketHandler
    implements WebSocketListener {
        private HmtpReader _in;
        private HmtpWriter _out;

        HmtpWebSocketHandler() {
        }

        public void onStart(WebSocketContext context) throws IOException {
            this._out = new HmtpWriter(context.getOutputStream());
            HmtpClient.this.setLinkStream(new HempMemoryQueue(this._out, HmtpClient.this.getActorStream(), 1));
            this._in = new HmtpReader(context.getInputStream());
        }

        public void onRead(WebSocketContext context) throws IOException {
            InputStream is = context.getInputStream();
            while (this._in.readPacket(HmtpClient.this.getActorStream()) && is.available() > 0) {
            }
        }

        public void onComplete(WebSocketContext context) throws IOException {
        }

        public void onTimeout(WebSocketContext context) throws IOException {
        }
    }
}

