/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.deployclient;

import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.TimeoutException;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.j2ee.deployclient.ProgressObjectImpl;
import com.caucho.j2ee.deployclient.TargetImpl;
import com.caucho.j2ee.deployclient.TargetModuleIDImpl;
import com.caucho.server.admin.DeployClient;
import com.caucho.server.admin.HostQuery;
import com.caucho.server.admin.StatusQuery;
import com.caucho.server.admin.TagQuery;
import com.caucho.util.L10N;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.QDocument;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlPrinter;
import com.caucho.xpath.XPath;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.w3c.dom.Node;

public class DeploymentManagerImpl
implements DeploymentManager {
    private static final L10N L = new L10N(DeploymentManagerImpl.class);
    private static final Logger log = Logger.getLogger(DeploymentManagerImpl.class.getName());
    private DeployClient _deployClient;
    private final String _host;
    private final int _port;
    private String _user;
    private String _password;
    private String _uri;

    DeploymentManagerImpl(String uri) {
        int p = uri.indexOf("http");
        if (p < 0) {
            throw new IllegalArgumentException(L.l("'{0}' is an illegal URI for DeploymentManager.", uri));
        }
        this._uri = uri;
        int hostIdx = uri.indexOf("://") + 3;
        int portIdx = uri.indexOf(58, hostIdx);
        int fileIdx = uri.indexOf(47, portIdx + 1);
        this._host = uri.substring(hostIdx, portIdx);
        this._port = fileIdx > -1 ? Integer.parseInt(uri.substring(portIdx + 1, fileIdx)) : Integer.parseInt(uri.substring(portIdx + 1));
    }

    void connect(String user, String password) throws DeploymentManagerCreationException {
        this._user = user;
        this._password = password;
        this._deployClient = new DeployClient(this._host, this._port, this._user, this._password);
    }

    private void reset() {
        this._deployClient = new DeployClient(this._host, this._port, this._user, this._password);
    }

    public Target[] getTargets() throws IllegalStateException {
        try {
            HostQuery[] hosts = this._deployClient.listHosts();
            if (hosts == null) {
                throw new IllegalStateException(L.l("'{0}' does not return any hosts", this._deployClient));
            }
            Target[] targets = new Target[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                HostQuery host = hosts[i];
                TargetImpl target = new TargetImpl(host.getName(), null);
                targets[i] = target;
            }
            return targets;
        }
        catch (RemoteConnectionFailedException e) {
            this.reset();
            return this.getTargets();
        }
        catch (TimeoutException e) {
            this.reset();
            return this.getTargets();
        }
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getAvailableModules(moduleType, targetList);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        try {
            ArrayList<TargetModuleIDImpl> resultList = new ArrayList<TargetModuleIDImpl>();
            for (int i = 0; i < targetList.length; ++i) {
                Target target = targetList[i];
                TagQuery[] tags = this._deployClient.listTags(target.getName());
                for (int j = 0; tags != null && j < tags.length; ++j) {
                    String host = tags[j].getHost();
                    String tag = tags[j].getTag();
                    resultList.add(new TargetModuleIDImpl(new TargetImpl(host, null), tag));
                }
            }
            TargetModuleID[] result = new TargetModuleID[resultList.size()];
            resultList.toArray(result);
            return result;
        }
        catch (RemoteConnectionFailedException e) {
            this.reset();
            return this.getAvailableModules(moduleType, targetList);
        }
    }

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        throw new UnsupportedOperationException();
    }

    public ProgressObject distribute(Target[] targetList, File archive, File deploymentPlan) throws IllegalStateException {
        return this.distributeImpl(targetList, archive, null, deploymentPlan, null);
    }

    public ProgressObject distribute(Target[] targetList, InputStream archive, InputStream deploymentPlan) throws IllegalStateException {
        return this.distributeImpl(targetList, null, archive, null, deploymentPlan);
    }

    public ProgressObject distributeImpl(Target[] targetList, File archive, InputStream archiveStream, File deploymentPlan, InputStream deploymentPlanStream) throws IllegalStateException {
        try {
            QDocument doc = new QDocument();
            DOMBuilder builder = new DOMBuilder();
            builder.init(doc);
            Xml xml = new Xml();
            xml.setOwner(doc);
            xml.setNamespaceAware(false);
            xml.setContentHandler(builder);
            xml.setCoalescing(true);
            if (deploymentPlan != null) {
                xml.parse(Vfs.lookup(deploymentPlan.getAbsolutePath()));
            } else {
                xml.parse(deploymentPlanStream);
            }
            String type = XPath.evalString("/deployment-plan/archive-type", doc);
            String name = XPath.evalString("/deployment-plan/name", doc);
            CommitBuilder commit = new CommitBuilder();
            if (type.equals("war")) {
                commit.type("webapp");
            }
            if (type.equals("ear")) {
                commit.type("entapp");
            }
            commit.tagKey("default/" + name);
            if (archive != null) {
                this._deployClient.commitArchive(commit, Vfs.lookup(archive.getAbsolutePath()));
            } else {
                this._deployClient.commitArchive(commit, archiveStream);
            }
            String tag = commit.getId();
            this._deployClient.deploy(tag);
            this.deployExtraFiles(tag, doc);
            TargetModuleID[] targetModules = new TargetModuleID[targetList.length];
            for (int i = 0; i < targetList.length; ++i) {
                Target target = targetList[i];
                targetModules[i] = new TargetModuleIDImpl((TargetImpl)target, tag);
            }
            ProgressObjectImpl result = new ProgressObjectImpl(targetModules);
            StatusQuery status = this._deployClient.status(tag);
            String archiveName = archive != null ? String.valueOf(archive) : "stream";
            if (status.getMessage() == null) {
                result.completed(L.l("application {0} deployed from {1}", (Object)name, archiveName));
            } else {
                result.failed(L.l("application {0} failed from {1}: {2}", name, archiveName, status.getMessage()));
            }
            return result;
        }
        catch (RemoteConnectionFailedException e) {
            this.reset();
            return this.distributeImpl(targetList, archive, archiveStream, deploymentPlan, deploymentPlanStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void deployExtraFiles(String tag, Node doc) {
        try {
            Iterator iter = XPath.select("/deployment-plan/ext-file", doc);
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                String name = XPath.evalString("name", node);
                Node data = XPath.find("data", node);
                if (data == null) continue;
                data = data.getFirstChild();
                TempOutputStream os = new TempOutputStream();
                XmlPrinter printer = new XmlPrinter(os);
                printer.printXml(data);
                os.close();
                long length = os.getLength();
                if (length == 0L) continue;
                InputStream is = os.openInputStreamNoFree();
                String sha1 = this._deployClient.calculateFileDigest(is, length);
                this._deployClient.sendFile(sha1, length, os.openInputStream());
                this._deployClient.deploy(tag);
                this._deployClient.addDeployFile(tag, name, sha1);
            }
        }
        catch (RemoteConnectionFailedException e) {
            this.reset();
            this.deployExtraFiles(tag, doc);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ProgressObject start(TargetModuleID[] moduleIDList) throws IllegalStateException {
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < moduleIDList.length; ++i) {
                TargetModuleID targetModuleID = moduleIDList[i];
                String host = targetModuleID.getTarget().getName();
                String tag = targetModuleID.getModuleID();
                this._deployClient.start(tag);
                sb.append(tag).append(' ');
            }
            ProgressObjectImpl result = new ProgressObjectImpl(moduleIDList);
            result.completed(L.l("modules ${0} started", sb.toString()));
            return result;
        }
        catch (RemoteConnectionFailedException e) {
            this.reset();
            return this.start(moduleIDList);
        }
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList) throws IllegalStateException {
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < moduleIDList.length; ++i) {
                TargetModuleID targetModuleID = moduleIDList[i];
                String host = targetModuleID.getTarget().getName();
                String tag = targetModuleID.getModuleID();
                this._deployClient.stop(tag);
                sb.append(tag).append(' ');
            }
            ProgressObjectImpl result = new ProgressObjectImpl(moduleIDList);
            result.completed(L.l("modules ${0} stop", sb.toString()));
            return result;
        }
        catch (RemoteConnectionFailedException e) {
            this.reset();
            return this.stop(moduleIDList);
        }
    }

    public ProgressObject undeploy(TargetModuleID[] moduleIDList) throws IllegalStateException {
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < moduleIDList.length; ++i) {
                TargetModuleID targetModuleID = moduleIDList[i];
                String host = targetModuleID.getTarget().getName();
                String tag = targetModuleID.getModuleID();
                CommitBuilder builder = new CommitBuilder();
                builder.type("webapp");
                builder.tagKey(tag);
                this._deployClient.undeploy(builder);
                sb.append(tag).append(' ');
            }
            ProgressObjectImpl result = new ProgressObjectImpl(moduleIDList);
            result.completed(L.l("modules ${0} undeployed", sb.toString()));
            return result;
        }
        catch (RemoteConnectionFailedException e) {
            this.reset();
            return this.undeploy(moduleIDList);
        }
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetList, File archive, File deploymentPlan) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public ProgressObject redeploy(TargetModuleID[] targetList, InputStream archive, InputStream deploymentPlan) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void release() {
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException();
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException();
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException();
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException();
    }

    public boolean isLocaleSupported(Locale locale) {
        return false;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V1_4;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return true;
    }

    public void setDConfigBeanVersionSupported(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
    }

    public String toString() {
        return "DeploymentManagerImpl[" + this._uri + "]";
    }

    public ProgressObject distribute(Target[] arg0, ModuleType arg1, InputStream arg2, InputStream arg3) throws IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType arg0) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

