/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import javax.annotation.PostConstruct;

public class WorkDir {
    private static final EnvironmentLocal<Path> _localWorkDir = new EnvironmentLocal("caucho.work-dir");
    private Path _path;

    public static Path getLocalWorkDir() {
        return WorkDir.getLocalWorkDir(Thread.currentThread().getContextClassLoader());
    }

    public static Path getLocalWorkDir(ClassLoader loader) {
        Path path = _localWorkDir.get(loader);
        if (path != null) {
            return path;
        }
        path = WorkDir.getTmpWorkDir();
        _localWorkDir.setGlobal(path);
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static Path getTmpWorkDir() {
        String userName = System.getProperty("user.name");
        Path path = CauchoSystem.isWindows() && !Alarm.isTest() ? Vfs.lookup("file:/c:/tmp/" + userName) : Vfs.lookup("file:/tmp/" + userName);
        return path;
    }

    public static void setLocalWorkDir(Path path) {
        WorkDir.setLocalWorkDir(path, Thread.currentThread().getContextClassLoader());
    }

    public static void setLocalWorkDir(Path path, ClassLoader loader) {
        try {
            if (path instanceof MergePath) {
                path = ((MergePath)path).getWritePath();
            }
            if (path instanceof MemoryPath) {
                String pathName = path.getPath();
                path = WorkDir.getTmpWorkDir().lookup("qa/" + pathName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        _localWorkDir.set(path, loader);
    }

    public void setValue(Path path) {
        this._path = path;
    }

    public void setId(Path path) throws IOException {
        this.setValue(path);
    }

    @PostConstruct
    public void init() {
        WorkDir.setLocalWorkDir(this._path);
    }
}

